/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.pipeline;

import java.io.IOException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.codehaus.plexus.summit.AbstractSummitComponent;
import org.codehaus.plexus.summit.exception.SummitException;
import org.codehaus.plexus.summit.pipeline.Pipeline;
import org.codehaus.plexus.summit.pipeline.valve.Valve;
import org.codehaus.plexus.summit.pipeline.valve.ValveContext;
import org.codehaus.plexus.summit.rundata.RunData;

public class SummitPipeline
extends AbstractSummitComponent
implements Pipeline,
ValveContext,
Initializable,
Configurable,
ThreadSafe {
    protected String name;
    protected Valve[] valves;
    protected ThreadLocal state = new ThreadLocal();
    private Configuration configuration;

    public void initialize() throws Exception {
        this.name = this.configuration.getChild("name").getValue();
        Configuration[] ids = this.configuration.getChild("valveComponentIds").getChildren();
        this.valves = new Valve[ids.length];
        int i = 0;
        while (i < ids.length) {
            if (ids[i].getName().equals("valveId")) {
                String valveId = ids[i].getValue();
                this.getLogger().info("Adding Valve: " + valveId);
                this.valves[i] = (Valve)this.getServiceManager().lookup(Valve.ROLE + valveId);
            }
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public void invoke(RunData data) throws SummitException, IOException {
        this.state.set(new Integer(0));
        this.invokeNext(data);
    }

    public void invokeNext(RunData data) throws SummitException, IOException {
        Integer current = (Integer)this.state.get();
        int subscript = current;
        if (subscript < this.valves.length) {
            this.state.set(new Integer(subscript + 1));
            this.valves[subscript].invoke(data, this);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }
}

