/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.siterenderer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.doxia.Doxia;
import org.codehaus.doxia.module.xhtml.decoration.render.RenderingContext;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.module.SiteModule;
import org.codehaus.doxia.site.module.manager.SiteModuleManager;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.siterenderer.Renderer;
import org.codehaus.plexus.siterenderer.RendererException;
import org.codehaus.plexus.siterenderer.sink.SiteRendererSink;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.VelocityComponent;

public class DefaultSiteRenderer
extends AbstractLogEnabled
implements Renderer {
    private static final String DEFAULT_OUTPUT_ENCODING = "UTF-8";
    private VelocityComponent velocity;
    private SiteModuleManager siteModuleManager;
    private Doxia doxia;
    private I18N i18n;
    private String currentDocument;
    private RenderingContext renderingContext;
    private ClassLoader templateClassLoader;
    private Xpp3Dom siteDescriptor;
    private Locale defaultLocale = Locale.ENGLISH;

    public void setTemplateClassLoader(ClassLoader templateClassLoader) {
        this.templateClassLoader = templateClassLoader;
    }

    public void render(File siteDirectory, File outputDirectory, File siteDescriptor, String templateName, Map templateProperties) throws RendererException, IOException {
        this.render(siteDirectory, outputDirectory, siteDescriptor, templateName, templateProperties, this.defaultLocale);
    }

    public void render(File siteDirectory, File outputDirectory, File siteDescriptor, String templateName, Map templateProperties, Locale locale) throws RendererException, IOException {
        this.render(siteDirectory, outputDirectory, new FileInputStream(siteDescriptor), templateName, templateProperties, locale);
    }

    public void render(File siteDirectory, File outputDirectory, String siteDescriptor, String templateName, Map templateProperties) throws RendererException, IOException {
        this.render(siteDirectory, outputDirectory, siteDescriptor, templateName, templateProperties, this.defaultLocale);
    }

    public void render(File siteDirectory, File outputDirectory, String siteDescriptor, String templateName, Map templateProperties, Locale locale) throws RendererException, IOException {
        this.render(siteDirectory, outputDirectory, (InputStream)new StringInputStream(siteDescriptor), templateName, templateProperties, locale);
    }

    public void render(File siteDirectory, File outputDirectory, InputStream siteDescriptor, String templateName, Map templateProperties) throws RendererException, IOException {
        this.render(siteDirectory, outputDirectory, siteDescriptor, templateName, templateProperties, this.defaultLocale);
    }

    public void render(File siteDirectory, File outputDirectory, InputStream siteDescriptor, String templateName, Map templateProperties, Locale locale) throws RendererException, IOException {
        this.render(siteDirectory, outputDirectory, siteDescriptor, templateName, templateProperties, this.defaultLocale, DEFAULT_OUTPUT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(File siteDirectory, File outputDirectory, InputStream siteDescriptor, String templateName, Map templateProperties, Locale locale, String outputEncoding) throws RendererException, IOException {
        try {
            InputStreamReader xmlReader = new InputStreamReader(siteDescriptor);
            this.siteDescriptor = Xpp3DomBuilder.build((Reader)xmlReader);
        }
        catch (XmlPullParserException e) {
            throw new RendererException("Can't read site descriptor.", e);
        }
        Iterator i = this.siteModuleManager.getSiteModules().iterator();
        while (i.hasNext()) {
            SiteModule module = (SiteModule)i.next();
            File moduleBasedir = new File(siteDirectory, module.getSourceDirectory());
            if (!moduleBasedir.exists()) continue;
            List docs = FileUtils.getFileNames((File)moduleBasedir, (String)("**/*." + module.getExtension()), null, (boolean)false);
            Iterator j = docs.iterator();
            while (j.hasNext()) {
                String doc = (String)j.next();
                String outputName = doc.substring(0, doc.indexOf(".") + 1) + "html";
                String fullPathDoc = new File(moduleBasedir, doc).getPath();
                SiteRendererSink sink = this.createSink(moduleBasedir, outputName);
                try {
                    FileReader reader = new FileReader(fullPathDoc);
                    this.doxia.parse((Reader)reader, module.getParserId(), (Sink)sink);
                    File outputFile = new File(outputDirectory, outputName);
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    this.generateDocument(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outputEncoding), templateName, templateProperties, sink, locale);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.getLogger().error("Error rendering " + fullPathDoc + ": " + e.getMessage(), (Throwable)e);
                }
                finally {
                    sink.flush();
                    sink.close();
                }
            }
        }
    }

    public void generateDocument(Writer writer, String templateName, Map templateProperties, SiteRendererSink sink) throws RendererException {
        this.generateDocument(writer, templateName, templateProperties, sink, this.defaultLocale);
    }

    public void generateDocument(Writer writer, String templateName, Map templateProperties, SiteRendererSink sink, Locale locale) throws RendererException {
        VelocityContext context = new VelocityContext();
        context.put("relativePath", (Object)this.renderingContext.getRelativePath());
        context.put("authors", (Object)sink.getAuthors());
        context.put("title", (Object)sink.getTitle());
        context.put("bodyContent", (Object)sink.getBody());
        context.put("siteDescriptor", (Object)this.siteDescriptor);
        context.put("currentDate", (Object)new Date());
        context.put("currentFileName", (Object)PathTool.calculateLink((String)("/" + this.currentDocument), (String)this.renderingContext.getRelativePath()));
        context.put("locale", (Object)locale);
        if (templateProperties != null) {
            Iterator i = templateProperties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                context.put(key, templateProperties.get(key));
            }
        }
        context.put("PathTool", (Object)new PathTool());
        context.put("FileUtils", (Object)new FileUtils());
        context.put("StringUtils", (Object)new StringUtils());
        context.put("i18n", (Object)this.i18n);
        this.writeTemplate(templateName, writer, (Context)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTemplate(String templateName, Writer writer, Context context) throws RendererException {
        Template template = null;
        ClassLoader old = null;
        if (this.templateClassLoader != null) {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.templateClassLoader);
        }
        try {
            try {
                template = this.velocity.getEngine().getTemplate(templateName);
            }
            catch (Exception e) {
                throw new RendererException("Could not find the template '" + templateName + "' in " + Thread.currentThread().getContextClassLoader());
            }
            try {
                template.merge(context, writer);
                writer.close();
            }
            catch (Exception e) {
                throw new RendererException("Error while generating code.", e);
            }
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public SiteRendererSink createSink(File moduleBaseDir, String document, File siteDescriptor) throws RendererException, IOException {
        return this.createSink(moduleBaseDir, document, new FileInputStream(siteDescriptor));
    }

    public SiteRendererSink createSink(File moduleBaseDir, String document, String siteDescriptor) throws RendererException, IOException {
        return this.createSink(moduleBaseDir, document, (InputStream)new StringInputStream(siteDescriptor));
    }

    public SiteRendererSink createSink(File moduleBaseDir, String document, InputStream siteDescriptor) throws RendererException, IOException {
        try {
            InputStreamReader xmlReader = new InputStreamReader(siteDescriptor);
            this.siteDescriptor = Xpp3DomBuilder.build((Reader)xmlReader);
        }
        catch (XmlPullParserException e) {
            throw new RendererException("Can't read site descriptor.", e);
        }
        return this.createSink(moduleBaseDir, document);
    }

    private SiteRendererSink createSink(File moduleBaseDir, String document) throws RendererException {
        this.currentDocument = document;
        this.renderingContext = new RenderingContext(moduleBaseDir, document, null);
        return new SiteRendererSink(new StringWriter(), this.renderingContext);
    }
}

