/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.servlet;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.lifecycle.avalon.AvalonServiceManager;

final class ServletContextUtils {
    static final String PLEXUS_CONFIG_PARAM = "plexus-config";
    private static final String DEFAULT_PLEXUS_CONFIG = "/WEB-INF/plexus.xml";

    private ServletContextUtils() {
    }

    private static String resolveConfig(ServletContext context, String plexusConf) {
        if (plexusConf == null) {
            plexusConf = context.getInitParameter(PLEXUS_CONFIG_PARAM);
        }
        if (plexusConf == null) {
            plexusConf = DEFAULT_PLEXUS_CONFIG;
        }
        return plexusConf;
    }

    static Embedder createContainer(ServletContext context, String plexusConf) throws ServletException {
        Embedder embedder = new Embedder();
        String realPath = context.getRealPath("/WEB-INF");
        if (realPath != null) {
            File f = new File(realPath);
            embedder.addContextValue((Object)"plexus.home", (Object)f.getAbsolutePath());
        } else {
            context.log("Not setting plexus.home as plexus is running inside webapp with no 'real path'");
        }
        try {
            plexusConf = ServletContextUtils.resolveConfig(context, plexusConf);
            embedder.setConfiguration(context.getResource(plexusConf));
            embedder.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException("Could not start Plexus!", (Throwable)e);
        }
        PlexusContainer plexus = embedder.getContainer();
        context.setAttribute("plexus", (Object)plexus);
        AvalonServiceManager serviceManager = new AvalonServiceManager(plexus.getComponentRepository());
        context.setAttribute("plexus:service-manager", (Object)serviceManager);
        return embedder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroyContainer(Embedder embedder, ServletContext context) {
        try {
            if (embedder != null) {
                embedder.stop();
            }
        }
        catch (Exception e) {
            context.log("Trying to dispose of Plexus container", (Throwable)e);
        }
        finally {
            context.removeAttribute("plexus");
            context.removeAttribute("plexus:service-manager");
        }
    }
}

