/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.codehaus.plexus.PlexusContainer;

public final class PlexusServletUtils {
    private PlexusServletUtils() {
    }

    public static ServiceManager getServiceManager(ServletContext sc) {
        return (ServiceManager)sc.getAttribute("plexus:service-manager");
    }

    public static PlexusContainer getPlexusContainer(ServletContext sc) {
        return (PlexusContainer)sc.getAttribute("plexus");
    }

    public static boolean hasService(ServletContext sc, String role) throws ServletException {
        return PlexusServletUtils.getServiceManager(sc).hasService(role);
    }

    public static boolean hasService(ServletContext sc, String role, String id) throws ServletException {
        String selectorName = role + "Selector";
        ServiceManager serviceManager = PlexusServletUtils.getServiceManager(sc);
        if (!serviceManager.hasService(selectorName)) {
            return false;
        }
        try {
            Object o = serviceManager.lookup(selectorName);
            ServiceSelector selector = (ServiceSelector)o;
            return selector.isSelectable((Object)id);
        }
        catch (ServiceException e) {
            throw new ServletException("could not lookup service", (Throwable)e);
        }
    }

    public static Object lookup(ServletContext sc, String role) throws ServletException {
        try {
            return PlexusServletUtils.getServiceManager(sc).lookup(role);
        }
        catch (ServiceException e) {
            throw new ServletException("could not lookup service", (Throwable)e);
        }
    }

    public static Object lookup(ServletContext sc, String role, String id) throws ServletException {
        String selectorName = role + "Selector";
        ServiceManager serviceManager = PlexusServletUtils.getServiceManager(sc);
        try {
            Object o = serviceManager.lookup(selectorName);
            ServiceSelector selector = (ServiceSelector)o;
            return selector.select((Object)id);
        }
        catch (ServiceException e) {
            throw new ServletException("could not lookup service", (Throwable)e);
        }
    }

    public static void release(ServletContext sc, Object service) throws ServletException {
        PlexusServletUtils.getServiceManager(sc).release(service);
    }
}

