/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.avalon.framework.service.ServiceManager;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.servlet.PlexusServletUtils;
import org.codehaus.plexus.servlet.ServletContextUtils;

public class PlexusServletContextListener
implements ServletContextListener {
    private Embedder embedder = null;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        String configName = context.getInitParameter("plexus-config");
        context.log("Initializing Plexus container...");
        try {
            this.embedder = ServletContextUtils.createContainer(context, configName);
        }
        catch (ServletException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        context.log("Plexus container initialized.");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        context.log("Disposing of Plexus container.");
        ServletContextUtils.destroyContainer(this.embedder, context);
    }

    public static ServiceManager getServiceManager(ServletContext sc) {
        return PlexusServletUtils.getServiceManager(sc);
    }

    public static PlexusContainer getPlexusContainer(ServletContext sc) {
        return PlexusServletUtils.getPlexusContainer(sc);
    }
}

