/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.servlet;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.util.PropertyUtils;

final class ServletContextUtils {
    private static final String PLEXUS_HOME = "plexus.home";
    static final String PLEXUS_CONFIG_PARAM = "plexus-config";
    private static final String PLEXUS_PROPERTIES_PARAM = "plexus-properties";
    private static final String DEFAULT_PLEXUS_CONFIG = "/WEB-INF/plexus.xml";
    private static final String DEFAULT_PLEXUS_PROPERTIES = "/WEB-INF/plexus.properties";

    private ServletContextUtils() {
    }

    private static String resolveConfig(ServletContext context, String plexusConf) {
        if (plexusConf == null) {
            plexusConf = context.getInitParameter(PLEXUS_CONFIG_PARAM);
        }
        if (plexusConf == null) {
            plexusConf = DEFAULT_PLEXUS_CONFIG;
        }
        return plexusConf;
    }

    private static Properties resolveContextProperties(ServletContext context) {
        Properties properties = new Properties();
        String filename = context.getInitParameter(PLEXUS_PROPERTIES_PARAM);
        if (filename == null) {
            filename = DEFAULT_PLEXUS_PROPERTIES;
        }
        context.log("Loading plexus context properties from: '" + filename + "'");
        try {
            URL url = context.getResource(filename);
            properties = PropertyUtils.loadProperties((URL)url);
        }
        catch (Exception e) {
            context.log("Could not load plexus context properties from: '" + filename + "'");
        }
        if (properties == null) {
            context.log("Could not load plexus context properties from: '" + filename + "'");
            properties = new Properties();
        }
        if (!((Hashtable)properties).containsKey(PLEXUS_HOME)) {
            ServletContextUtils.setPlexusHome(context, properties);
        }
        return properties;
    }

    private static void setPlexusHome(ServletContext context, Properties contexProperties) {
        String realPath = context.getRealPath("/WEB-INF");
        if (realPath != null) {
            File f = new File(realPath);
            contexProperties.setProperty(PLEXUS_HOME, f.getAbsolutePath());
        } else {
            context.log("Not setting 'plexus.home' as plexus is running inside webapp with no 'real path'");
        }
    }

    static Embedder createContainer(ServletContext context, String plexusConf) throws ServletException {
        Embedder embedder = new Embedder();
        try {
            plexusConf = ServletContextUtils.resolveConfig(context, plexusConf);
            embedder.setConfiguration(context.getResource(plexusConf));
            Properties properties = ServletContextUtils.resolveContextProperties(context);
            embedder.setProperties(properties);
            embedder.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException("Could not start Plexus!", (Throwable)e);
        }
        PlexusContainer plexus = embedder.getContainer();
        context.setAttribute("plexus", (Object)plexus);
        return embedder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroyContainer(Embedder embedder, ServletContext context) {
        try {
            if (embedder != null) {
                embedder.stop();
            }
        }
        catch (Exception e) {
            context.log("Trying to dispose of Plexus container", (Throwable)e);
        }
        finally {
            context.removeAttribute("plexus");
        }
    }
}

