/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.service.xmlrpc;

import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.plexus.application.profile.ApplicationRuntimeProfile;
import org.codehaus.plexus.application.service.PlexusService;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StartingException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.xmlrpc.XmlRpcServer;

public class XmlRpcPlexusService
extends AbstractLogEnabled
implements PlexusService,
Startable {
    private XmlRpcServer xmlRpcServer;
    private int port;

    public void start() throws StartingException {
        try {
            this.xmlRpcServer.addListener(null, this.port, false);
            this.xmlRpcServer.startListener(null, this.port);
        }
        catch (XmlRpcException e) {
            throw new StartingException("Error while starting XML-RPC server.", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.xmlRpcServer.removeListener(null, this.port);
        }
        catch (XmlRpcException e) {
            this.getLogger().error("Error while stopping the XML-RPC server.", (Throwable)e);
        }
    }

    public void beforeApplicationStart(ApplicationRuntimeProfile applicationRuntimeProfile, PlexusConfiguration serviceConfiguration) throws Exception {
    }

    public void afterApplicationStart(ApplicationRuntimeProfile applicationRuntimeProfile, PlexusConfiguration serviceConfiguration) throws Exception {
        PlexusConfiguration[] handlers = serviceConfiguration.getChild("handlers").getChildren("handler");
        for (int i = 0; i < handlers.length; ++i) {
            PlexusConfiguration handler = handlers[i];
            String role = handler.getChild("role").getValue();
            String name = handler.getChild("name").getValue();
            if (StringUtils.isEmpty((String)role)) {
                this.getLogger().error("Error in configuration: Missing 'role' child element of 'handler' element.");
                break;
            }
            if (StringUtils.isEmpty((String)name)) {
                this.getLogger().error("Error in configuration: Missing 'name' child element of 'handler' element.");
                break;
            }
            if (!applicationRuntimeProfile.getContainer().hasComponent(role)) {
                this.getLogger().error("No component with the role '" + role + "' available.");
                break;
            }
            Object component = applicationRuntimeProfile.getContainer().lookup(role);
            this.getLogger().info("Adding XML-RPC handler for role '" + role + " to name '" + name + "'.");
            this.xmlRpcServer.addHandler(name, component);
        }
    }
}

