/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.service.jetty.configuration.builder;

import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.service.jetty.configuration.HttpListener;
import org.codehaus.plexus.service.jetty.configuration.ProxyHttpListener;
import org.codehaus.plexus.service.jetty.configuration.ServiceConfiguration;
import org.codehaus.plexus.service.jetty.configuration.WebApplication;
import org.codehaus.plexus.service.jetty.configuration.builder.ServiceConfigurationBuilder;
import org.codehaus.plexus.util.StringUtils;

public class DefaultServiceConfigurationBuilder
extends AbstractLogEnabled
implements ServiceConfigurationBuilder {
    /*
     * WARNING - void declaration
     */
    public ServiceConfiguration buildConfiguration(PlexusConfiguration serviceConfiguration) {
        ServiceConfiguration configuration = new ServiceConfiguration();
        PlexusConfiguration[] webapps = serviceConfiguration.getChild("webapps").getChildren("webapp");
        for (int i = 0; i < webapps.length; ++i) {
            String file;
            String path = webapps[i].getChild("path").getValue(null);
            if (StringUtils.isEmpty((String)path)) {
                path = null;
            }
            if (StringUtils.isEmpty((String)(file = webapps[i].getChild("file").getValue(null)))) {
                file = null;
            }
            if (path == null && file == null) {
                this.getLogger().warn("Error while deploying web application: For each 'webapp' a 'path' or 'file' element has to be specified.");
                continue;
            }
            String extractionPath = webapps[i].getChild("extraction-path").getValue(null);
            if (StringUtils.isEmpty((String)extractionPath)) {
                this.getLogger().warn("Error while deploying web application: For each 'extraction-path' element has to be specified.");
                continue;
            }
            String context = webapps[i].getChild("context").getValue(null);
            if (StringUtils.isEmpty((String)context)) {
                this.getLogger().warn("Error while deploying web application: 'context' is missing or empty.");
                continue;
            }
            String virtualHost = webapps[i].getChild("virtual-host").getValue(null);
            if (StringUtils.isEmpty((String)virtualHost)) {
                virtualHost = null;
            }
            PlexusConfiguration[] listeners = webapps[i].getChild("listeners").getChildren();
            WebApplication app = new WebApplication(file, path, extractionPath, context, virtualHost);
            for (int j = 0; j < listeners.length; ++j) {
                void var15_15;
                HttpListener httpListener;
                PlexusConfiguration listener = listeners[j];
                String proxyPortString = listener.getChild("proxy-port").getValue(null);
                if (listener.getName().equals("http-listener")) {
                    int port = this.getPort(listener);
                    if (port == -1) continue;
                    httpListener = new HttpListener(this.getHost(listener), port);
                } else if (listener.getName().equals("proxy-http-listener")) {
                    String proxyHost = this.getProxyHost(listener);
                    if (StringUtils.isEmpty((String)proxyHost) || StringUtils.isEmpty((String)proxyPortString)) {
                        this.getLogger().warn("Both proxyHost and proxyPort has to be specified.");
                        continue;
                    }
                    int port = this.getPort(listener);
                    int proxyPort = this.getProxyPort(listener);
                    if (port == -1 || proxyPort == -1) continue;
                    httpListener = new ProxyHttpListener(this.getHost(listener), port, proxyHost, proxyPort);
                } else {
                    this.getLogger().warn("Unknown listener type '" + listener.getName() + "'.");
                    continue;
                }
                app.getListeners().add(var15_15);
            }
            if (app.getListeners().size() == 0) {
                this.getLogger().warn("At least one listener has to be configured before adding the web application.");
                continue;
            }
            configuration.addWebApplication(app);
        }
        return configuration;
    }

    private String getHost(PlexusConfiguration listener) {
        String host = listener.getChild("host").getValue(null);
        if (StringUtils.isEmpty((String)host)) {
            return null;
        }
        return host;
    }

    private int getPort(PlexusConfiguration listener) {
        String portString = listener.getChild("port").getValue(null);
        if (StringUtils.isEmpty((String)portString)) {
            this.getLogger().warn("Error while deploying web application: 'port' has to be a integer.");
            return -1;
        }
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            this.getLogger().warn("Error while deploying web application: 'port' has to be a integer.");
            return -1;
        }
    }

    private String getProxyHost(PlexusConfiguration listener) {
        String proxyHost = listener.getChild("proxy-host").getValue(null);
        if (StringUtils.isEmpty((String)proxyHost)) {
            proxyHost = null;
        }
        return proxyHost;
    }

    private int getProxyPort(PlexusConfiguration listener) {
        String proxyPortString = listener.getChild("proxy-port").getValue(null);
        if (StringUtils.isEmpty((String)proxyPortString)) {
            this.getLogger().warn("Error while deploying web application: 'proxy-port' has to be a integer.");
            return -1;
        }
        try {
            return Integer.parseInt(proxyPortString);
        }
        catch (NumberFormatException e) {
            this.getLogger().warn("Error while deploying web application: 'proxy-port' has to be a integer.");
            return -1;
        }
    }
}

