/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.service.jetty;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.codehaus.plexus.application.deploy.ApplicationDeployer;
import org.codehaus.plexus.application.profile.ApplicationRuntimeProfile;
import org.codehaus.plexus.application.service.PlexusService;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.service.jetty.ServletContainer;
import org.codehaus.plexus.service.jetty.ServletContainerException;
import org.codehaus.plexus.service.jetty.configuration.HttpListener;
import org.codehaus.plexus.service.jetty.configuration.ProxyHttpListener;
import org.codehaus.plexus.service.jetty.configuration.ServiceConfiguration;
import org.codehaus.plexus.service.jetty.configuration.WebApplication;
import org.codehaus.plexus.service.jetty.configuration.builder.ServiceConfigurationBuilder;
import org.codehaus.plexus.util.IOUtil;

public class JettyPlexusService
extends AbstractLogEnabled
implements PlexusService,
Initializable,
Startable {
    private ServiceConfigurationBuilder configurationBuilder;
    private ApplicationDeployer deployer;
    private ServletContainer servletContainer;

    public void initialize() {
        this.getLogger().info("Initializing servlet container service.");
    }

    public void start() {
        this.getLogger().info("Starting servlet container service.");
    }

    public void stop() {
        this.getLogger().info("Stopping servlet container service.");
    }

    public void beforeApplicationStart(ApplicationRuntimeProfile applicationRuntimeProfile, PlexusConfiguration serviceConfiguration) throws Exception {
        ServiceConfiguration configuration = this.configurationBuilder.buildConfiguration(serviceConfiguration);
        Iterator it = configuration.getWebapps().iterator();
        while (it.hasNext()) {
            File webAppDir;
            WebApplication application = (WebApplication)it.next();
            if (application.getPath() == null) {
                this.extractJarFile(new File(application.getFile()), application.getExtractionPath());
                webAppDir = new File(application.getExtractionPath());
            } else {
                webAppDir = new File(application.getPath());
            }
            this.deployDirectory(webAppDir, application.getContext(), application.getVirtualHost(), applicationRuntimeProfile);
        }
    }

    public void afterApplicationStart(ApplicationRuntimeProfile applicationRuntimeProfile, PlexusConfiguration serviceConfiguration) throws Exception {
        ServiceConfiguration configuration = this.configurationBuilder.buildConfiguration(serviceConfiguration);
        Iterator it = configuration.getWebapps().iterator();
        while (it.hasNext()) {
            WebApplication application = (WebApplication)it.next();
            if (!this.servletContainer.hasContext(application.getContext())) continue;
            if (application.getVirtualHost() == null) {
                this.getLogger().info("Deploying application '" + applicationRuntimeProfile.getName() + "'.");
            } else {
                this.getLogger().info("Deploying application '" + applicationRuntimeProfile.getName() + "' " + "on virtual host '" + application.getVirtualHost() + "'.");
            }
            Iterator it2 = application.getListeners().iterator();
            while (it2.hasNext()) {
                HttpListener httpListener = (HttpListener)it2.next();
                String listener = httpListener.getHost() != null ? httpListener.getHost() + ":" + httpListener.getPort() : "*:" + httpListener.getPort();
                if (httpListener instanceof ProxyHttpListener) {
                    ProxyHttpListener proxyHttpListener = (ProxyHttpListener)httpListener;
                    String proxyListener = proxyHttpListener.getHost() != null ? proxyHttpListener.getHost() + ":" + proxyHttpListener.getPort() : "*:" + proxyHttpListener.getPort();
                    this.getLogger().info("Adding HTTP proxy listener on " + listener + " for " + proxyListener);
                    this.servletContainer.addProxyListener(proxyHttpListener.getHost(), proxyHttpListener.getPort(), proxyHttpListener.getProxyHost(), proxyHttpListener.getProxyPort());
                    continue;
                }
                this.getLogger().info("Adding HTTP listener on " + listener);
                this.servletContainer.addListener(httpListener.getHost(), httpListener.getPort());
            }
            this.servletContainer.startApplication(application.getContext());
        }
    }

    private void deployDirectory(File directory, String context, String virtualHost, ApplicationRuntimeProfile runtimeProfile) throws Exception {
        if (!directory.isDirectory()) {
            throw new Exception("The webapp isn't a directory: '" + directory.getAbsolutePath() + "'.");
        }
        try {
            this.servletContainer.deployWarDirectory(directory, runtimeProfile.getContainer(), context, virtualHost);
        }
        catch (ServletContainerException e) {
            this.getLogger().error("Error while deploying WAR '" + directory.getAbsolutePath() + "'.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractJarFile(File file, String extractionPath) throws Exception {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        JarFile jarFile = new JarFile(file);
        try {
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                InputStream is = jarFile.getInputStream(entry);
                File outputFile = new File(extractionPath, entry.getName());
                if (entry.getName().endsWith("/")) {
                    if (outputFile.exists() || outputFile.mkdirs()) continue;
                    throw new Exception("Error while deploying web application: Could not make directory: '" + outputFile.getAbsolutePath() + "'.");
                }
                File parent = outputFile.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new Exception("Error while deploying web application: Could not make directory: '" + parent.getAbsolutePath() + "'.");
                }
                FileOutputStream os = new FileOutputStream(outputFile);
                IOUtil.copy((InputStream)is, (OutputStream)os);
            }
        }
        finally {
            jarFile.close();
        }
    }
}

