/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.service.jetty.configuration;

import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.service.jetty.configuration.ServiceConfiguration;
import org.codehaus.plexus.service.jetty.configuration.ServiceConfigurationBuilder;
import org.codehaus.plexus.service.jetty.configuration.WebApplication;
import org.codehaus.plexus.util.StringUtils;

public class DefaultServiceConfigurationBuilder
extends AbstractLogEnabled
implements ServiceConfigurationBuilder {
    public ServiceConfiguration buildConfiguration(PlexusConfiguration serviceConfiguration) {
        ServiceConfiguration configuration = new ServiceConfiguration();
        PlexusConfiguration[] webapps = serviceConfiguration.getChild("webapps").getChildren("webapp");
        for (int i = 0; i < webapps.length; ++i) {
            String portString;
            String file;
            String path = webapps[i].getChild("path").getValue(null);
            if (StringUtils.isEmpty((String)path)) {
                path = null;
            }
            if (StringUtils.isEmpty((String)(file = webapps[i].getChild("file").getValue(null)))) {
                file = null;
            }
            if (path == null && file == null) {
                this.getLogger().warn("Error while deploying web application: For each 'webapp' a 'path' or 'file' element has to be specified.");
                continue;
            }
            String extractionPath = webapps[i].getChild("extractionPath").getValue(null);
            if (StringUtils.isEmpty((String)extractionPath)) {
                this.getLogger().warn("Error while deploying web application: For each 'extractionPath' element has to be specified.");
                continue;
            }
            String context = webapps[i].getChild("context").getValue(null);
            if (StringUtils.isEmpty((String)context)) {
                this.getLogger().warn("Error while deploying web application: 'context' is missing or empty.");
                continue;
            }
            String virtualHost = webapps[i].getChild("virtualHost").getValue(null);
            if (StringUtils.isEmpty((String)virtualHost)) {
                virtualHost = null;
            }
            if (StringUtils.isEmpty((String)(portString = webapps[i].getChild("port").getValue(null)))) {
                this.getLogger().warn("Error while deploying web application: 'port' is missing or empty.");
                continue;
            }
            int port = 0;
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                this.getLogger().warn("Error while deploying web application: 'port' is not a number.");
                continue;
            }
            WebApplication app = new WebApplication(file, path, extractionPath, context, virtualHost, port);
            configuration.addWebApplication(app);
        }
        return configuration;
    }
}

