/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.service.jetty;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StartingException;
import org.codehaus.plexus.service.jetty.ServletContainer;
import org.codehaus.plexus.service.jetty.ServletContainerException;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.MultiException;

public class JettyServletContainer
extends AbstractLogEnabled
implements ServletContainer,
Startable {
    private Server server;

    public void start() throws StartingException {
        this.server = new Server();
        try {
            this.server.start();
        }
        catch (MultiException e) {
            throw new StartingException("Error while starting Jetty", (Throwable)e);
        }
    }

    public void stop() {
        if (this.server.isStarted()) {
            while (true) {
                try {
                    this.server.stop(true);
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            this.server.destroy();
        }
    }

    public boolean hasContext(String contextPath) {
        HttpContext[] contexts = this.server.getContexts();
        HttpContext context = null;
        for (int i = 0; i < contexts.length; ++i) {
            context = contexts[i];
            if (!context.getContextPath().equals(contextPath)) continue;
            return true;
        }
        return false;
    }

    public void addListener(String address, int port) throws ServletContainerException, UnknownHostException {
        HttpListener listener;
        InetAddrPort addrPort = new InetAddrPort(address, port);
        try {
            listener = this.server.addListener(addrPort);
        }
        catch (IOException e) {
            throw new ServletContainerException("Error while adding listener on address: '" + address + "', port: " + port + ".", (Throwable)e);
        }
        try {
            listener.start();
        }
        catch (Exception e) {
            throw new ServletContainerException("Error while starting listener on address: '" + address + "', port: " + port + ".", (Throwable)e);
        }
    }

    public void deployWarFile(File war, boolean extractWar, File extractionLocation, DefaultPlexusContainer container, String context, String virtualHost, int port) throws ServletContainerException {
        this.deployWAR(war, extractWar, extractionLocation, container, context, virtualHost);
    }

    public void deployWarDirectory(File war, String context, String virtualHost, int port, DefaultPlexusContainer container) throws ServletContainerException {
        this.deployWAR(war, false, null, container, context, virtualHost);
    }

    public void startApplication(String contextPath) throws ServletContainerException {
        try {
            this.getContext(contextPath).start();
        }
        catch (Exception e) {
            throw new ServletContainerException("Error while starting the web application.", (Throwable)e);
        }
    }

    private HttpContext getContext(String contextPath) throws ServletContainerException {
        HttpContext[] contexts = this.server.getContexts();
        HttpContext context = null;
        for (int i = 0; i < contexts.length; ++i) {
            context = contexts[i];
            if (!context.getContextPath().equals(contextPath)) continue;
            return context;
        }
        throw new ServletContainerException("No such context '" + contextPath + "'.");
    }

    private void deployWAR(File war, boolean extractWar, File extractionLocation, DefaultPlexusContainer container, String context, String virtualHost) throws ServletContainerException {
        WebApplicationContext applicationContext;
        if (war == null) {
            throw new ServletContainerException("Invalid parameter: 'war' cannot be null.");
        }
        if (context == null) {
            throw new ServletContainerException("Invalid parameter: 'context' cannot be null.");
        }
        try {
            applicationContext = virtualHost != null ? this.server.addWebApplication(virtualHost, context, war.getAbsolutePath()) : this.server.addWebApplication(context, war.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ServletContainerException("Error while deploying WAR.", (Throwable)e);
        }
        applicationContext.setExtractWAR(extractWar);
        if (extractionLocation != null) {
            applicationContext.setTempDirectory(extractionLocation);
        }
        applicationContext.setClassLoader(container.getCoreRealm().getClassLoader());
        applicationContext.getServletContext().setAttribute("plexus", (Object)container);
    }
}

