/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.security.summit;

import org.codehaus.plexus.security.summit.User;
import org.codehaus.plexus.security.summit.session.SessionBindingEventProxy;
import org.codehaus.plexus.summit.rundata.DefaultRunData;
import org.codehaus.plexus.summit.view.ViewContext;

public class SecureRunData
extends DefaultRunData {
    public static final String USER_SESSION_KEY = "user.session";
    private User user;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ViewContext getViewContext() {
        return (ViewContext)this.getMap().get("viewContext");
    }

    public boolean hasUser() {
        return this.getUser() != null;
    }

    public User getUser() {
        if (this.user == null) {
            this.user = this.getUserFromSession();
        }
        return this.user;
    }

    public void setUser(User user) {
        if (user != null) {
            this.getSession().setAttribute(USER_SESSION_KEY, (Object)new SessionBindingEventProxy(user));
        } else {
            this.removeUserFromSession();
        }
        this.user = user;
    }

    public User getUserFromSession() {
        try {
            SessionBindingEventProxy proxy = (SessionBindingEventProxy)this.getSession().getAttribute(USER_SESSION_KEY);
            return proxy == null ? null : (User)proxy.getListener();
        }
        catch (ClassCastException e) {
            String message = "User object did not implement User interface.  if you are sure the interface is implemented, the user object in the session and this class may be loaded from different classloaders.  This has been known to happen when using multiple turbine apps in tomcat that interact through the use of RequestDispatcher.include or forward.";
            this.getLogger().error(message, (Throwable)e);
            return null;
        }
    }

    public boolean removeUserFromSession() {
        try {
            this.getSession().removeAttribute(USER_SESSION_KEY);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

