/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.security.summit;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.action.Action;
import org.codehaus.plexus.action.ActionManager;
import org.codehaus.plexus.action.ActionNotFoundException;
import org.codehaus.plexus.security.ResourceController;
import org.codehaus.plexus.security.summit.SecureRunData;
import org.codehaus.plexus.summit.pipeline.valve.AbstractValve;
import org.codehaus.plexus.summit.pipeline.valve.ValveInvocationException;
import org.codehaus.plexus.summit.rundata.RunData;

public class SecureActionValve
extends AbstractValve {
    private String notAuthorizedPage = "NotAuthroized.vm";
    private ResourceController controller;
    private ActionManager actionManager;

    public void invoke(RunData data) throws IOException, ValveInvocationException {
        SecureRunData sdata = (SecureRunData)data;
        String actionId = data.getParameters().getString("action", "").trim();
        if (!actionId.equals("")) {
            Action action = null;
            try {
                action = this.actionManager.lookup(actionId);
            }
            catch (ActionNotFoundException e) {
                this.getLogger().error("Cannot find action with the id of " + actionId, (Throwable)e);
                return;
            }
            if (this.controller.isAuthorized(sdata.getUser(), actionId)) {
                try {
                    Map m = this.createContext(data);
                    m.put("data", data);
                    action.execute(m);
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
            } else {
                data.setTarget(this.notAuthorizedPage);
            }
        }
    }

    protected Map createContext(RunData data) {
        HashMap<String, String> m = new HashMap<String, String>();
        Enumeration e = data.getRequest().getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            m.put(key, data.getRequest().getParameter(key));
        }
        return m;
    }
}

