/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.scm;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.scm.NoSuchScmProviderException;
import org.codehaus.plexus.scm.ScmManager;

public class DefaultScmManager
extends AbstractLogEnabled
implements ScmManager,
Initializable {
    private Map scmProviders;
    private List loggers = new ArrayList();
    private static final String ILLEGAL_SCM_URL = "The scm url must be on the form 'scm:<scm provider><delimiter><provider specific part>' where <delimiter> can be either ':' or '|'.";
    static /* synthetic */ Class class$org$apache$maven$scm$command$checkout$CheckOutScmResult;
    static /* synthetic */ Class class$org$apache$maven$scm$command$checkin$CheckInScmResult;
    static /* synthetic */ Class class$org$apache$maven$scm$command$tag$TagScmResult;
    static /* synthetic */ Class class$org$apache$maven$scm$command$update$UpdateScmResult;
    static /* synthetic */ Class class$org$apache$maven$scm$command$diff$DiffScmResult;
    static /* synthetic */ Class class$org$apache$maven$scm$command$changelog$ChangeLogScmResult;
    static /* synthetic */ Class class$org$apache$maven$scm$command$status$StatusScmResult;
    static /* synthetic */ Class class$org$apache$maven$scm$command$add$AddScmResult;

    public void initialize() {
        if (this.scmProviders == null) {
            this.scmProviders = new HashMap();
        }
        if (this.scmProviders.size() == 0) {
            this.getLogger().warn("No SCM providers configured.");
        }
    }

    public ScmRepository makeScmRepository(String scmUrl) throws ScmRepositoryException, NoSuchScmProviderException {
        if (scmUrl == null) {
            throw new NullPointerException("The scm url cannot be null.");
        }
        char delimiter = this.findDelimiter(scmUrl);
        String providerType = scmUrl.substring(4, scmUrl.indexOf(delimiter, 4));
        ScmProvider provider = this.getScmProvider(providerType);
        String scmSpecificUrl = scmUrl.substring(providerType.length() + 5);
        ScmProviderRepository providerRepository = provider.makeProviderScmRepository(scmSpecificUrl, delimiter);
        return new ScmRepository(providerType, providerRepository);
    }

    public ScmRepository makeProviderScmRepository(String providerType, File path) throws ScmRepositoryException, UnknownRepositoryStructure, NoSuchScmProviderException {
        if (providerType == null) {
            throw new NullPointerException("The provider type cannot be null.");
        }
        ScmProvider provider = this.getScmProvider(providerType);
        ScmProviderRepository providerRepository = provider.makeProviderScmRepository(path);
        return new ScmRepository(providerType, providerRepository);
    }

    public List validateScmRepository(String scmUrl) {
        ScmProvider provider;
        char delimiter;
        ArrayList<String> messages = new ArrayList<String>();
        if (scmUrl == null) {
            throw new NullPointerException("The scm url cannot be null.");
        }
        if (!scmUrl.startsWith("scm:")) {
            messages.add("The scm url must start with 'scm:'.");
            return messages;
        }
        if (scmUrl.length() < 6) {
            messages.add(ILLEGAL_SCM_URL);
            return messages;
        }
        try {
            delimiter = this.findDelimiter(scmUrl);
        }
        catch (ScmRepositoryException e) {
            messages.add(e.getMessage());
            return messages;
        }
        String providerType = scmUrl.substring(4, scmUrl.indexOf(delimiter, 4));
        try {
            provider = this.getScmProvider(providerType);
        }
        catch (NoSuchScmProviderException e) {
            messages.add("No such provider installed '" + providerType + "'.");
            return messages;
        }
        String scmSpecificUrl = scmUrl.substring(providerType.length() + 5);
        List providerMessages = provider.validateScmUrl(scmSpecificUrl, delimiter);
        if (providerMessages == null) {
            throw new RuntimeException("The SCM provider cannot return null from validateScmUrl().");
        }
        messages.addAll(providerMessages);
        return messages;
    }

    public CheckOutScmResult checkOut(ScmRepository repository, ScmFileSet fileSet, String tag) throws ScmException {
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        ScmResult scmResult = this.execute("check-out", repository, fileSet, parameters);
        return (CheckOutScmResult)this.checkScmResult(class$org$apache$maven$scm$command$checkout$CheckOutScmResult == null ? (class$org$apache$maven$scm$command$checkout$CheckOutScmResult = DefaultScmManager.class$("org.apache.maven.scm.command.checkout.CheckOutScmResult")) : class$org$apache$maven$scm$command$checkout$CheckOutScmResult, scmResult);
    }

    public CheckInScmResult checkIn(ScmRepository repository, ScmFileSet fileSet, String tag, String message) throws ScmException {
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        parameters.setString(CommandParameter.MESSAGE, message);
        ScmResult scmResult = this.execute("check-in", repository, fileSet, parameters);
        return (CheckInScmResult)this.checkScmResult(class$org$apache$maven$scm$command$checkin$CheckInScmResult == null ? (class$org$apache$maven$scm$command$checkin$CheckInScmResult = DefaultScmManager.class$("org.apache.maven.scm.command.checkin.CheckInScmResult")) : class$org$apache$maven$scm$command$checkin$CheckInScmResult, scmResult);
    }

    public TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, String tag) throws ScmException {
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        ScmResult scmResult = this.execute("tag", repository, fileSet, parameters);
        return (TagScmResult)this.checkScmResult(class$org$apache$maven$scm$command$tag$TagScmResult == null ? (class$org$apache$maven$scm$command$tag$TagScmResult = DefaultScmManager.class$("org.apache.maven.scm.command.tag.TagScmResult")) : class$org$apache$maven$scm$command$tag$TagScmResult, scmResult);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, String tag) throws ScmException {
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        ScmResult scmResult = this.execute("update", repository, fileSet, parameters);
        return (UpdateScmResult)this.checkScmResult(class$org$apache$maven$scm$command$update$UpdateScmResult == null ? (class$org$apache$maven$scm$command$update$UpdateScmResult = DefaultScmManager.class$("org.apache.maven.scm.command.update.UpdateScmResult")) : class$org$apache$maven$scm$command$update$UpdateScmResult, scmResult);
    }

    public DiffScmResult diff(ScmRepository repository, ScmFileSet fileSet, String startRevision, String endRevision) throws ScmException {
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.START_REVISION, startRevision);
        parameters.setString(CommandParameter.END_REVISION, endRevision);
        ScmResult scmResult = this.execute("diff", repository, fileSet, parameters);
        return (DiffScmResult)this.checkScmResult(class$org$apache$maven$scm$command$diff$DiffScmResult == null ? (class$org$apache$maven$scm$command$diff$DiffScmResult = DefaultScmManager.class$("org.apache.maven.scm.command.diff.DiffScmResult")) : class$org$apache$maven$scm$command$diff$DiffScmResult, scmResult);
    }

    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, String branch) throws ScmException {
        CommandParameters parameters = new CommandParameters();
        parameters.setDate(CommandParameter.START_DATE, startDate);
        parameters.setDate(CommandParameter.END_DATE, endDate);
        parameters.setString(CommandParameter.BRANCH, branch);
        ScmResult scmResult = this.execute("change-log", repository, fileSet, parameters);
        return (ChangeLogScmResult)this.checkScmResult(class$org$apache$maven$scm$command$changelog$ChangeLogScmResult == null ? (class$org$apache$maven$scm$command$changelog$ChangeLogScmResult = DefaultScmManager.class$("org.apache.maven.scm.command.changelog.ChangeLogScmResult")) : class$org$apache$maven$scm$command$changelog$ChangeLogScmResult, scmResult);
    }

    public StatusScmResult status(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        CommandParameters parameters = new CommandParameters();
        ScmResult scmResult = this.execute("status", repository, fileSet, parameters);
        return (StatusScmResult)this.checkScmResult(class$org$apache$maven$scm$command$status$StatusScmResult == null ? (class$org$apache$maven$scm$command$status$StatusScmResult = DefaultScmManager.class$("org.apache.maven.scm.command.status.StatusScmResult")) : class$org$apache$maven$scm$command$status$StatusScmResult, scmResult);
    }

    public AddScmResult add(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.MESSAGE, "");
        parameters.setString(CommandParameter.BINARY, "false");
        ScmResult scmResult = this.execute("add", repository, fileSet, parameters);
        return (AddScmResult)this.checkScmResult(class$org$apache$maven$scm$command$add$AddScmResult == null ? (class$org$apache$maven$scm$command$add$AddScmResult = DefaultScmManager.class$("org.apache.maven.scm.command.add.AddScmResult")) : class$org$apache$maven$scm$command$add$AddScmResult, scmResult);
    }

    public void addListener(ScmLogger logger) throws NoSuchScmProviderException {
        this.loggers.add(logger);
    }

    private ScmResult execute(String commandName, ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        ScmProvider scmProvider = this.getScmProvider(repository.getProvider());
        Iterator i = this.loggers.iterator();
        while (i.hasNext()) {
            ScmLogger logger = (ScmLogger)i.next();
            scmProvider.addListener(logger);
        }
        return scmProvider.execute(commandName, repository.getProviderRepository(), fileSet, parameters);
    }

    private char findDelimiter(String scmUrl) throws ScmRepositoryException {
        int index = (scmUrl = scmUrl.substring(4)).indexOf(124);
        if (index == -1 && (index = scmUrl.indexOf(58)) == -1) {
            throw new ScmRepositoryException(ILLEGAL_SCM_URL);
        }
        return scmUrl.charAt(index);
    }

    private ScmProvider getScmProvider(String providerType) throws NoSuchScmProviderException {
        ScmProvider scmProvider = (ScmProvider)this.scmProviders.get(providerType);
        if (scmProvider == null) {
            throw new NoSuchScmProviderException(providerType);
        }
        return scmProvider;
    }

    private ScmResult checkScmResult(Class clazz, ScmResult scmResult) throws ScmException {
        if (!clazz.isAssignableFrom(scmResult.getClass())) {
            throw new ScmException("Internal error: Wrong ScmResult returned. Expected: " + clazz.getName() + ". " + "Got: " + scmResult.getClass().getName());
        }
        return scmResult;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

