/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.scheduler;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.plexus.classloader.PlexusClassLoader;
import org.apache.plexus.context.Contextualizable;
import org.apache.plexus.context.PlexusContext;
import org.apache.plexus.scheduler.DefaultJobListener;
import org.apache.plexus.scheduler.Scheduler;
import org.apache.plexus.service.ServiceBroker;
import org.apache.plexus.service.Serviceable;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.StdSchedulerFactory;

public class DefaultScheduler
extends AbstractLogEnabled
implements Scheduler,
Contextualizable,
Configurable,
Initializable,
Startable,
ThreadSafe,
Serviceable {
    private PlexusContext context;
    private Properties schedulerProperties;
    private StdScheduler scheduler;
    private File jobDirectory;
    private ServiceBroker serviceBroker;
    private Configuration inlineJobConfigurations;
    static /* synthetic */ Class class$org$apache$plexus$scheduler$DefaultScheduler;

    public void setJobDirectory(File jobDirectory) {
        this.jobDirectory = jobDirectory;
    }

    public File getJobDirectory() {
        return this.jobDirectory;
    }

    public void setInlineJobConfigurations(Configuration configurations) {
        this.inlineJobConfigurations = configurations;
    }

    public Configuration getInlineJobConfigurations() {
        return this.inlineJobConfigurations;
    }

    Properties getSchedulerProperties() {
        return this.schedulerProperties;
    }

    StdScheduler getScheduler() {
        return this.scheduler;
    }

    PlexusContext getContext() {
        return this.context;
    }

    ServiceBroker getServiceBroker() {
        return this.serviceBroker;
    }

    public void scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        this.getLogger().info("scheduling job: " + jobDetail + " " + trigger);
        this.getScheduler().scheduleJob(jobDetail, trigger);
    }

    public void contextualize(PlexusContext context) throws ContextException {
        this.getLogger().info("contextualize");
        this.context = context;
    }

    public void service(ServiceBroker serviceBroker) {
        this.serviceBroker = serviceBroker;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.getLogger().info("configure");
        this.configureComponent(configuration);
        this.configureScheduler(configuration.getChild("scheduler", true));
    }

    void configureComponent(Configuration configuration) throws ConfigurationException {
        this.setInlineJobConfigurations(configuration.getChild("jobs"));
        String jobDir = configuration.getChild("job-directory").getValue("");
        if (jobDir == null || jobDir.equals("")) {
            this.getLogger().info("job directory specified");
            return;
        }
        File plexusWorkDir = this.getContext().getWorkDirectory();
        if (plexusWorkDir == null) {
            this.getLogger().warn("no plexus deployment directory - static job jars will not be loaded");
            return;
        }
        File jobDirectory = new File(plexusWorkDir, jobDir);
        if (!jobDirectory.exists()) {
            jobDirectory.mkdirs();
        }
        this.setJobDirectory(jobDirectory);
    }

    void configureScheduler(Configuration configuration) throws ConfigurationException {
        this.schedulerProperties = new Properties();
        Configuration[] propConfigs = configuration.getChildren("property");
        String name = null;
        String value = null;
        int i = 0;
        while (i < propConfigs.length) {
            name = propConfigs[i].getAttribute("name");
            value = propConfigs[i].getAttribute("value");
            this.schedulerProperties.setProperty(name, value);
            ++i;
        }
    }

    public void initialize() throws Exception {
        this.getLogger().info("initialize");
        this.initializeScheduler();
        this.initializeJobsFiles();
        this.initializeInlineJobs();
    }

    void initializeScheduler() throws Exception {
        StdSchedulerFactory factory = new StdSchedulerFactory(this.getSchedulerProperties());
        this.scheduler = (StdScheduler)factory.getScheduler();
        DefaultJobListener jobListener = new DefaultJobListener();
        this.scheduler.addGlobalJobListener((JobListener)jobListener);
    }

    void initializeJobsFiles() throws Exception {
        File jobDir = this.getJobDirectory();
        if (jobDir == null) {
            this.getLogger().info("no job directory configured");
            return;
        }
        File[] jobFiles = jobDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
            }
        });
        int i = 0;
        while (i < jobFiles.length) {
            this.initializeJobFile(jobFiles[i]);
            ++i;
        }
    }

    public void addJobFile(File jobFile) throws Exception {
        this.getLogger().info("adding job file: " + jobFile.getPath());
        this.initializeJobFile(jobFile);
    }

    void initializeJobFile(File jobFile) throws Exception {
        JarFile jarFile = new JarFile(jobFile);
        Enumeration<JarEntry> entryEnum = jarFile.entries();
        ZipEntry eachEntry = null;
        while (entryEnum.hasMoreElements()) {
            eachEntry = entryEnum.nextElement();
            if (!eachEntry.getName().equals("jobs.xml")) continue;
            this.initializeJobFile(jobFile, jarFile.getInputStream(eachEntry));
            break;
        }
    }

    void initializeJobFile(File jobFile, InputStream jobsConfigStream) throws Exception {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        this.getLogger().info("reading jobs.xml");
        Configuration jobsConfig = builder.build(jobsConfigStream);
        jobsConfigStream.close();
        ClassLoader parent = (class$org$apache$plexus$scheduler$DefaultScheduler == null ? (class$org$apache$plexus$scheduler$DefaultScheduler = DefaultScheduler.class$("org.apache.plexus.scheduler.DefaultScheduler")) : class$org$apache$plexus$scheduler$DefaultScheduler).getClassLoader();
        PlexusClassLoader loader = new PlexusClassLoader(parent);
        loader.addURL(jobFile.toURL());
        this.initializeJobs((ClassLoader)loader, jobsConfig, jobFile.toString());
    }

    void initializeInlineJobs() {
        if (this.getInlineJobConfigurations() == null) {
            return;
        }
        this.getLogger().info("reading inline job specifications");
        ClassLoader loader = (class$org$apache$plexus$scheduler$DefaultScheduler == null ? (class$org$apache$plexus$scheduler$DefaultScheduler = DefaultScheduler.class$("org.apache.plexus.scheduler.DefaultScheduler")) : class$org$apache$plexus$scheduler$DefaultScheduler).getClassLoader();
        this.initializeJobs(loader, this.getInlineJobConfigurations(), "inline source");
    }

    void initializeJobs(ClassLoader loader, Configuration jobsConfig, String source) {
        Configuration[] jobConfigs = jobsConfig.getChildren("job");
        int i = 0;
        while (i < jobConfigs.length) {
            try {
                this.initializeJob(loader, jobConfigs[i]);
            }
            catch (Exception e) {
                this.getLogger().error("error initializing job from " + source, (Throwable)e);
            }
            ++i;
        }
    }

    void initializeJob(ClassLoader loader, Configuration jobConfig) throws Exception {
        String name = jobConfig.getChild("name").getValue();
        String group = jobConfig.getChild("group").getValue();
        String className = jobConfig.getChild("class").getValue();
        String cronSpec = jobConfig.getChild("cron-spec").getValue();
        Configuration jobExecutionConfiguration = jobConfig.getChild("configuration");
        this.getLogger().info("new job: " + group + "/" + name + " " + className + " " + cronSpec);
        Class<?> jobClass = loader.loadClass(className);
        JobDetail jobDetail = new JobDetail(name, group, jobClass);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put((Object)"JOB_LOGGER", (Object)this.getLogger());
        jobDataMap.put((Object)"JOB_CONTEXT", (Object)this.getContext());
        jobDataMap.put((Object)"JOB_SERVICE_BROKER", (Object)this.getServiceBroker());
        jobDataMap.put((Object)"JOB_EXECUTION_CONFIGURATION", (Object)jobExecutionConfiguration);
        jobDataMap.setAllowsTransientData(true);
        CronTrigger trigger = new CronTrigger(name, group, name, group, cronSpec);
        this.scheduleJob(jobDetail, (Trigger)trigger);
    }

    public void start() throws Exception {
        this.getLogger().info("starting scheduler");
        this.getScheduler().start();
    }

    public void stop() throws Exception {
        this.getLogger().info("stopping scheduler");
        this.getScheduler().shutdown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

