/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.builder.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.builder.AbstractBuilder;
import org.codehaus.plexus.builder.application.ApplicationBuilder;
import org.codehaus.plexus.builder.application.ApplicationBuilderException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public class DefaultApplicationBuilder
extends AbstractBuilder
implements ApplicationBuilder {
    public void assemble(String applicationName, File workingDirectory, List remoteRepositories, ArtifactRepository localRepository, Set projectArtifacts, Set serviceArtifacts, File applicationConfiguration, File configurationsDirectory, File configurationPropertiesFile) throws ApplicationBuilderException {
        Set artifacts;
        File libDir;
        if (applicationName == null || applicationName.trim().length() == 0) {
            throw new ApplicationBuilderException("The application name must be set.");
        }
        if (configurationPropertiesFile != null && !configurationPropertiesFile.isFile()) {
            throw new ApplicationBuilderException("The configuration properties file isn't a file: '" + configurationPropertiesFile.getAbsolutePath() + "'.");
        }
        if (configurationsDirectory != null && !configurationsDirectory.isDirectory()) {
            throw new ApplicationBuilderException("The configurations directory isn't a directory: '" + configurationsDirectory.getAbsolutePath() + ".");
        }
        if (!applicationConfiguration.exists()) {
            throw new ApplicationBuilderException("The application configuration file doesn't exist: '" + applicationConfiguration.getAbsolutePath() + "'.");
        }
        try {
            File confDir = this.mkdirs(new File(workingDirectory, "conf"));
            libDir = this.mkdirs(new File(workingDirectory, "lib"));
            File logsDir = this.mkdirs(new File(workingDirectory, "logs"));
            this.mkdirs(new File(workingDirectory, "META-INF/plexus"));
            new FileWriter(new File(logsDir, "foo")).close();
            this.processConfigurations(confDir, applicationConfiguration, configurationPropertiesFile, configurationsDirectory);
        }
        catch (IOException e) {
            throw new ApplicationBuilderException("Error while processing the configurations.", e);
        }
        try {
            HashSet excludedArtifacts = new HashSet();
            excludedArtifacts.addAll(this.getBootArtifacts(projectArtifacts, remoteRepositories, localRepository, true));
            excludedArtifacts.addAll(this.getCoreArtifacts(projectArtifacts, remoteRepositories, localRepository, true));
            serviceArtifacts = this.findArtifacts(remoteRepositories, localRepository, serviceArtifacts, true, null);
            excludedArtifacts.addAll(serviceArtifacts);
            excludedArtifacts.addAll(this.getExcludedArtifacts(projectArtifacts, remoteRepositories, localRepository));
            AbstractBuilder.AndArtifactFilter filter = new AbstractBuilder.AndArtifactFilter(new AbstractBuilder.ScopeExcludeArtifactFilter("test"), new AbstractBuilder.GroupArtifactTypeArtifactFilter(excludedArtifacts));
            artifacts = this.findArtifacts(remoteRepositories, localRepository, projectArtifacts, true, filter);
        }
        catch (ArtifactResolutionException e) {
            throw new ApplicationBuilderException("Error while finding dependencies.", e);
        }
        try {
            this.copyArtifacts(workingDirectory, libDir, artifacts);
        }
        catch (IOException e) {
            throw new ApplicationBuilderException("Error while copying dependencies.", e);
        }
        try {
            File descriptor = new File(workingDirectory, "META-INF/plexus/application.xml");
            FileWriter writer = new FileWriter(descriptor);
            PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter((Writer)writer);
            writer.write(System.getProperty("line.separator"));
            xmlWriter.startElement("plexus-application");
            xmlWriter.startElement("name");
            xmlWriter.writeText(applicationName);
            xmlWriter.endElement();
            xmlWriter.endElement();
            writer.write(System.getProperty("line.separator"));
            writer.close();
        }
        catch (IOException e) {
            throw new ApplicationBuilderException("Error while writing the application descriptor.", e);
        }
    }

    public void bundle(File outputFile, File workingDirectory) throws ApplicationBuilderException {
        JarArchiver archiver = new JarArchiver();
        try {
            archiver.addDirectory(workingDirectory);
            archiver.setDestFile(outputFile);
            archiver.createArchive();
        }
        catch (Exception e) {
            throw new ApplicationBuilderException("Error while creating the application archive.", e);
        }
    }

    private void processConfigurations(File confDir, File applicationConfiguration, File configurationPropertiesFile, File configurationsDirectory) throws IOException, ApplicationBuilderException {
        Properties configurationProperties = new Properties();
        if (configurationPropertiesFile != null) {
            configurationProperties.load(new FileInputStream(configurationPropertiesFile));
        }
        if (configurationsDirectory != null) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(configurationsDirectory);
            ArrayList<String> excludes = new ArrayList<String>();
            excludes.add("**/CVS/**");
            excludes.add("**/.svn/**");
            if (configurationPropertiesFile != null) {
                excludes.add(configurationPropertiesFile.getAbsolutePath());
            }
            scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                File in = new File(configurationsDirectory, file);
                File out = new File(confDir, file);
                File parent = out.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new ApplicationBuilderException("Could not make parent directories for '" + out.getAbsolutePath() + "'.");
                }
                this.filterCopy(in, out, (Map)configurationProperties);
            }
        }
        this.filterCopy(applicationConfiguration, new File(confDir, "application.xml"), (Map)configurationProperties);
    }
}

