/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.pull;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.summit.pull.PullService;
import org.codehaus.plexus.summit.pull.RequestTool;
import org.codehaus.plexus.summit.rundata.RunData;
import org.codehaus.plexus.summit.view.ViewContext;

public class DefaultPullService
extends AbstractLogEnabled
implements PullService,
Initializable,
Configurable,
Serviceable,
Disposable,
ThreadSafe {
    public static final String GLOBAL_SCOPE = "global";
    public static final String REQUEST_SCOPE = "request";
    public static final String SESSION_SCOPE = "session";
    private Map globalTools = new HashMap();
    private Map sessionTools = new HashMap();
    private Map requestTools = new HashMap();
    private Map globalContextTools = new HashMap();
    private ServiceManager manager;

    public void initialize() throws Exception {
        this.initializeGlobalTools();
    }

    protected void initializeGlobalTools() throws Exception {
        Iterator itr = this.getGlobalTools().keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            String componentKey = (String)this.getGlobalTools().get(key);
            Object component = this.manager.lookup(componentKey);
            this.globalContextTools.put(key, component);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] tools = configuration.getChildren("tool");
        this.configureScope(tools, this.globalTools, GLOBAL_SCOPE);
        this.configureScope(tools, this.sessionTools, SESSION_SCOPE);
        this.configureScope(tools, this.requestTools, REQUEST_SCOPE);
    }

    protected void configureScope(Configuration[] tools, Map toolMap, String scope) {
        int i = 0;
        while (i < tools.length) {
            try {
                if (tools[i].getAttribute("scope").equals(scope)) {
                    String toolName = tools[i].getAttribute("name");
                    String toolRoleName = tools[i].getAttribute("role");
                    toolMap.put(toolName, toolRoleName);
                    this.getLogger().info("Added tool class " + toolRoleName + " to the the context as '$" + toolName + "'");
                }
            }
            catch (ConfigurationException e) {
                this.getLogger().error("There was an error with the configuration!", (Throwable)e);
            }
            ++i;
        }
    }

    public void populateContext(ViewContext context, RunData data) {
        this.populateWithGlobalTools(context);
        this.populateWithRequestTools(context, data);
        this.populateWithSessionTools(context, data);
    }

    protected void populateWithGlobalTools(ViewContext context) {
        Iterator itr = this.globalContextTools.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            try {
                Object component = this.manager.lookup((String)this.getGlobalTools().get(key));
                context.put(key, component);
                this.getLogger().debug("Addded tool $" + key + " to the context.");
            }
            catch (ServiceException e) {
                this.getLogger().error("Couldn't find request tool " + key + " with role " + this.getGlobalTools().get(key) + ".", (Throwable)e);
            }
        }
    }

    protected void populateWithRequestTools(ViewContext context, RunData data) {
        Iterator itr = this.getRequestTools().keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            try {
                Object component = this.manager.lookup((String)this.getRequestTools().get(key));
                this.setRequestRunData(component, data);
                context.put(key, component);
                this.getLogger().debug("Addded tool $" + key + " to the context.");
            }
            catch (ServiceException e) {
                this.getLogger().error("Couldn't find request tool " + key + " with role " + this.getRequestTools().get(key) + ".", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateWithSessionTools(ViewContext context, RunData data) {
        Iterator itr = this.getSessionTools().keySet().iterator();
        while (itr.hasNext()) {
            HttpSession session;
            String key = (String)itr.next();
            HttpSession httpSession = session = data.getSession();
            synchronized (httpSession) {
                Object tool = session.getAttribute(key);
                if (tool == null) {
                    try {
                        tool = this.manager.lookup((String)this.getSessionTools().get(key));
                        session.setAttribute(key, tool);
                    }
                    catch (ServiceException e) {
                        this.getLogger().error("Could find request tool " + key + " with role " + this.getSessionTools().get(key) + ".", (Throwable)e);
                        break;
                    }
                }
                context.put(key, tool);
                this.getLogger().debug("Addded tool $" + key + " to the context.");
            }
        }
    }

    protected void setRequestRunData(Object component, RunData data) {
        if (component instanceof RequestTool) {
            ((RequestTool)component).setRunData(data);
        }
    }

    public void releaseTools(ViewContext context) {
        this.releaseTools(context, this.getRequestTools());
    }

    protected void releaseTools(ViewContext context, Map tools) {
        Iterator itr = tools.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object tool = context.remove(key);
            this.manager.release(tool);
        }
    }

    public Map getGlobalTools() {
        return this.globalTools;
    }

    public Map getRequestTools() {
        return this.requestTools;
    }

    public Map getSessionTools() {
        return this.sessionTools;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void dispose() {
        this.disposeGlobalTools();
        this.manager = null;
    }

    private void disposeGlobalTools() {
        Iterator itr = this.globalContextTools.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            this.manager.release(this.getGlobalTools().remove(key));
        }
    }
}

