/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.notification;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.notification.NotificationDispatcher;
import org.codehaus.plexus.notification.NotificationException;
import org.codehaus.plexus.notification.RecipientSource;
import org.codehaus.plexus.notification.notifier.Notifier;
import org.codehaus.plexus.notification.notifier.manager.NotifierManager;

public class DefaultNotificationDispatcher
extends AbstractLogEnabled
implements NotificationDispatcher {
    private NotifierManager notifierManager;
    private RecipientSource recipientSource;

    public void sendNotification(String messageId, Map context) throws NotificationException {
        this.sendNotification(messageId, Collections.EMPTY_MAP, context);
    }

    public void sendNotification(String messageId, Properties configuration, Map context) throws NotificationException {
        HashMap<String, String> conf = new HashMap<String, String>();
        Iterator i = ((Hashtable)configuration).keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = configuration.getProperty(key);
            conf.put(key, value);
        }
        if (conf.isEmpty()) {
            this.sendNotification(messageId, context);
        } else {
            this.sendNotification(messageId, conf, context);
        }
    }

    public void sendNotification(String messageId, Map configuration, Map context) throws NotificationException {
        Map notifiers = this.notifierManager.getNotifiers();
        Iterator it = notifiers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String notifierType = (String)entry.getKey();
            Notifier notifier = (Notifier)entry.getValue();
            Set recipients = this.recipientSource.getRecipients(notifierType, messageId, context);
            if (recipients == null) {
                this.getLogger().error("RecipientSource.getRecipients() returned null. Message id: '" + messageId + "', " + "notifier type: '" + notifierType + "'.");
                continue;
            }
            try {
                notifier.sendNotification(messageId, recipients, configuration, context);
            }
            catch (NotificationException e) {
                this.getLogger().warn("Error while sending notification.", (Throwable)e);
            }
        }
    }

    public void sendNotification(String messageId, Properties configuration) throws NotificationException {
        Map notifiers = this.notifierManager.getNotifiers();
        Iterator it = notifiers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String notifierType = (String)entry.getKey();
            Notifier notifier = (Notifier)entry.getValue();
            Set recipients = this.recipientSource.getRecipients(notifierType, messageId, null);
            if (recipients == null) {
                this.getLogger().error("RecipientSource.getRecipients() returned null. Message id: '" + messageId + "', " + "notifier type: '" + notifierType + "'.");
                continue;
            }
            try {
                notifier.sendNotification(messageId, recipients, configuration);
            }
            catch (NotificationException e) {
                this.getLogger().warn("Error while sending notification.", (Throwable)e);
            }
        }
    }
}

