/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.msn;

import java.io.IOException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.msn.LoginAdapter;
import org.codehaus.plexus.msn.MsnClient;
import org.codehaus.plexus.msn.MsnException;
import rath.msnm.MSNMessenger;
import rath.msnm.SwitchboardSession;
import rath.msnm.event.MsnListener;
import rath.msnm.msg.MimeMessage;

public class DefaultMsnClient
extends AbstractLogEnabled
implements MsnClient {
    private String login;
    private String password;
    private MSNMessenger msn;
    private String initialStatus = "NLN";

    public void login() throws MsnException {
        this.msn = new MSNMessenger(this.login, this.password);
        this.msn.setInitialStatus(this.initialStatus);
        LoginAdapter adapter = new LoginAdapter(this.msn, this.getLogger());
        this.msn.addMsnListener((MsnListener)adapter);
        this.msn.login();
        this.getLogger().info("Connection. Waiting for the response....");
        while (adapter.getStatus() == -1) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (adapter.getStatus() == 1) {
            throw new MsnException("Login failed : " + adapter.getError());
        }
    }

    public void logout() throws MsnException {
        if (this.msn != null) {
            this.msn.logout();
        }
    }

    public void sendMessage(String recipient, String message) throws MsnException {
        SwitchboardSession ss = null;
        try {
            ss = this.msn.doCallWait(recipient);
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            while (ss == null) {
                ss = this.msn.doCallWait(recipient);
            }
        }
        catch (InterruptedException e) {
            System.out.println("session docallwait InterruptedException:");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("session docallwait:");
            e.printStackTrace();
        }
        if (ss == null) {
            throw new MsnException("Can't create a SwitchboardSession.");
        }
        MimeMessage msg = new MimeMessage();
        msg.setKind(2);
        msg.setMessage(message);
        try {
            ss.sendInstantMessage(msg);
        }
        catch (IOException e) {
            throw new MsnException("The message isn't send.", e);
        }
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLogin() {
        return this.login;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

