/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.mimetyper;

import java.io.File;
import java.util.Locale;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.mimetyper.MimeTyper;
import org.codehaus.plexus.mimetyper.util.CharSetMap;
import org.codehaus.plexus.mimetyper.util.MimeType;
import org.codehaus.plexus.mimetyper.util.MimeTypeMap;

public class DefaultMimeTyper
extends AbstractLogEnabled
implements MimeTyper,
Configurable,
Initializable {
    public static final String MIME_TYPES = "mimetypes";
    public static final String CHARSETS = "charsets";
    private String mimetypePath;
    private String charsetPath;
    private MimeTypeMap mimeTypeMap;
    private CharSetMap charSetMap;

    public void setContentType(String spec) {
        this.mimeTypeMap.setContentType(spec);
    }

    public String getContentType(File file) {
        return this.mimeTypeMap.getContentType(file);
    }

    public String getContentType(String name) {
        return this.mimeTypeMap.getContentType(name);
    }

    public String getContentType(String ext, String def) {
        return this.mimeTypeMap.getContentType(ext, def);
    }

    public MimeType getMimeContentType(File file) {
        return this.mimeTypeMap.getMimeContentType(file);
    }

    public MimeType getMimeContentType(String name) {
        return this.mimeTypeMap.getMimeContentType(name);
    }

    public MimeType getMimeContentType(String ext, String def) {
        return this.mimeTypeMap.getMimeContentType(ext, def);
    }

    public String getDefaultExtension(String type) {
        return this.mimeTypeMap.getDefaultExtension(type);
    }

    public String getDefaultExtension(MimeType mime) {
        return this.mimeTypeMap.getDefaultExtension(mime);
    }

    public void setCharSet(String key, String charset) {
        this.charSetMap.setCharSet(key, charset);
    }

    public String getCharSet(Locale locale) {
        return this.charSetMap.getCharSet(locale);
    }

    public String getCharSet(Locale locale, String variant) {
        return this.charSetMap.getCharSet(locale, variant);
    }

    public String getCharSet(String key) {
        return this.charSetMap.getCharSet(key);
    }

    public String getCharSet(String key, String def) {
        return this.charSetMap.getCharSet(key, def);
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.mimetypePath = conf.getAttribute(MIME_TYPES, null);
        this.charsetPath = conf.getAttribute(CHARSETS, null);
    }

    public void initialize() throws Exception {
        this.mimeTypeMap = new MimeTypeMap(this.mimetypePath);
        this.charSetMap = new CharSetMap(this.charsetPath);
    }
}

