/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.factory.marmalade;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.marmalade.launch.MarmaladeLaunchException;
import org.codehaus.marmalade.launch.MarmaladeLauncher;
import org.codehaus.marmalade.metamodel.MarmaladeTaglibResolver;
import org.codehaus.marmalade.model.MarmaladeScript;
import org.codehaus.marmalade.model.MarmaladeTag;
import org.codehaus.marmalade.monitor.log.DefaultLog;
import org.codehaus.marmalade.monitor.log.MarmaladeLog;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.factory.ComponentFactory;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.factory.marmalade.PlexusComponentTag;
import org.codehaus.plexus.component.factory.marmalade.RealmDelegatingClassLoader;
import org.codehaus.plexus.component.repository.ComponentDescriptor;

public abstract class AbstractMarmaladeComponentFactory
implements ComponentFactory {
    private MarmaladeLog marmaladeLog = new DefaultLog();
    private String id = "marmalade";

    protected AbstractMarmaladeComponentFactory() {
    }

    public String getId() {
        return this.id;
    }

    public Object newInstance(ComponentDescriptor componentDescriptor, ClassRealm classRealm, PlexusContainer container) throws ComponentInstantiationException {
        ClassRealm componentRealm = container.getComponentRealm(componentDescriptor.getComponentKey());
        URL scriptLocation = this.getScriptLocation(componentDescriptor, componentRealm);
        Object result = null;
        try {
            result = this.parseComponent(scriptLocation, componentRealm);
        }
        catch (Exception e) {
            componentRealm.display();
            if (e instanceof ComponentInstantiationException) {
                throw (ComponentInstantiationException)e;
            }
            throw new ComponentInstantiationException("Cannot build component for: " + componentDescriptor.getComponentKey(), (Throwable)e);
        }
        return result;
    }

    protected abstract URL getScriptLocation(ComponentDescriptor var1, ClassRealm var2);

    public Object parseComponent(URL scriptLocation, ClassRealm realm) throws ComponentInstantiationException {
        Object result = null;
        try {
            URL it0015Resource2 = realm.getResource("META-INF/marmalade/it0015.def");
            this.marmaladeLog.log("info", (CharSequence)("it0015 taglib definition resource from component realm is: " + it0015Resource2));
            MarmaladeLauncher launcher = new MarmaladeLauncher();
            launcher.withLog(this.marmaladeLog);
            launcher.withInputURL(scriptLocation);
            launcher.withAdditionalTaglibDefinitionStrategies((Collection)MarmaladeTaglibResolver.NO_PASSTHROUGH_STRATEGY_CHAIN);
            this.marmaladeLog.log("info", (CharSequence)("Using classloader that delegates to realm: " + realm.getId()));
            launcher.withClassLoader((ClassLoader)new RealmDelegatingClassLoader(realm));
            MarmaladeScript script = launcher.buildScript();
            MarmaladeTag rootTag = script.getRoot();
            this.marmaladeLog.log("info", (CharSequence)("Root tag type: " + rootTag));
            PlexusComponentTag componentTag = (PlexusComponentTag)rootTag;
            launcher.run();
            result = componentTag.getComponent();
        }
        catch (IOException e) {
            throw new ComponentInstantiationException("Cannot read component script: " + scriptLocation, (Throwable)e);
        }
        catch (MarmaladeLaunchException e) {
            throw new ComponentInstantiationException("Error parsing component from script: " + scriptLocation, (Throwable)e);
        }
        return result;
    }
}

