/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.mailsender.simple;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.plexus.mailsender.AbstractMailSender;
import org.codehaus.plexus.mailsender.MailMessage;
import org.codehaus.plexus.mailsender.MailSenderException;
import org.codehaus.plexus.mailsender.simple.SimpleMailMessage;
import org.codehaus.plexus.mailsender.util.DateFormatUtils;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;

public class SimpleMailSender
extends AbstractMailSender
implements Initializable {
    public void initialize() throws InitializationException {
        if (StringUtils.isEmpty((String)this.getSmtpHost())) {
            throw new InitializationException("Error in configuration: Missing smtpHost.");
        }
        if (this.getSmtpPort() == 0) {
            this.setSmtpPort(25);
        }
    }

    public void send(MailMessage mail) throws MailSenderException {
        this.verify(mail);
        try {
            SimpleMailMessage message = new SimpleMailMessage(this.getSmtpHost(), this.getSmtpPort());
            message.from(mail.getFrom().getRfc2822Address());
            Iterator iter = mail.getToAddresses().iterator();
            while (iter.hasNext()) {
                message.to(((MailMessage.Address)iter.next()).getRfc2822Address());
            }
            iter = mail.getCcAddresses().iterator();
            while (iter.hasNext()) {
                message.cc(((MailMessage.Address)iter.next()).getRfc2822Address());
            }
            iter = mail.getBccAddresses().iterator();
            while (iter.hasNext()) {
                message.bcc(((MailMessage.Address)iter.next()).getRfc2822Address());
            }
            message.setSubject(mail.getSubject());
            Iterator it = mail.getHeaders().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String value = (String)entry.getValue();
                message.setHeader(entry.getKey().toString(), StringUtils.clean((String)value));
            }
            if (mail.getSendDate() != null) {
                message.setHeader("Date", DateFormatUtils.getDateHeader((Date)mail.getSendDate()));
            } else {
                message.setHeader("Date", DateFormatUtils.getDateHeader((Date)new Date()));
            }
            message.getPrintStream().print(mail.getContent());
            message.sendAndClose();
        }
        catch (IOException ex) {
            throw new MailSenderException("Error while sending mail.", (Throwable)ex);
        }
    }
}

