/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.mailsender;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.mailsender.MailMessage;
import org.codehaus.plexus.mailsender.MailSender;
import org.codehaus.plexus.mailsender.MailSenderException;

public abstract class AbstractMailSender
extends AbstractLogEnabled
implements MailSender {
    public static final int DEFAULT_SMTP_PORT = 25;
    private String smtpHost;
    private int smtpPort;
    private String username;

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void send(String subject, String content, String toMailbox, String toName, String fromMailbox, String fromName) throws MailSenderException {
        this.send(subject, content, toMailbox, toName, fromMailbox, fromName, new HashMap());
    }

    public void send(String subject, String content, String toMailbox, String toName, String fromMailbox, String fromName, Map headers) throws MailSenderException {
        MailMessage message = new MailMessage();
        message.setSubject(subject);
        message.setContent(content);
        message.setFrom(fromMailbox, fromName);
        message.addTo(toMailbox, toName);
        Iterator iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            message.addHeader(key, (String)headers.get(key));
        }
        this.send(message);
    }

    public void verify(MailMessage message) throws MailSenderException {
        MailMessage.Address from = message.getFrom();
        if (from.getMailbox() == null) {
            throw new MailSenderException("From mailbox isn't set.");
        }
        if (message.getToAddresses().size() == 0 && message.getCcAddresses().size() == 0 && message.getBccAddresses().size() == 0) {
            throw new MailSenderException("The mail requires at least one recipient.");
        }
    }

    public abstract /* synthetic */ void send(MailMessage var1) throws MailSenderException;
}

