/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.jabber;

import org.codehaus.plexus.jabber.JabberClient;
import org.codehaus.plexus.jabber.JabberClientException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

public class DefaultJabberClient
extends AbstractLogEnabled
implements JabberClient {
    private static final String RESOURCE_NAME = "plexus-jabber";
    private String host;
    private int port = -1;
    private String user;
    private String password;
    private boolean isSslConnection;
    private XMPPConnection conn;

    public void connect() throws JabberClientException {
        try {
            this.conn = !this.isSslConnection ? new XMPPConnection(this.getHost(), this.getPort()) : new SSLXMPPConnection(this.getHost(), this.getPort());
        }
        catch (XMPPException e) {
            throw new JabberClientException("Can't connect to " + this.getHost() + ":" + this.getPort(), e);
        }
    }

    public void disconnect() throws JabberClientException {
        if (this.conn != null) {
            if (this.conn.isConnected()) {
                this.conn.close();
            }
            this.conn = null;
        }
    }

    private XMPPConnection getConnection() throws JabberClientException {
        if (this.conn == null || !this.conn.isConnected()) {
            this.connect();
        }
        return this.conn;
    }

    public void logon() throws JabberClientException {
        block9: {
            XMPPConnection conn = this.getConnection();
            if (this.user != null) {
                try {
                    conn.login(this.user, this.password, RESOURCE_NAME);
                    if (!conn.isAuthenticated()) {
                        throw new JabberClientException("Authentication failed.");
                    }
                    break block9;
                }
                catch (XMPPException e) {
                    if (e.getXMPPError().getCode() == 401) {
                        this.getLogger().info("User " + this.user + " doesn't exist. Trying to create it.");
                        try {
                            conn.getAccountManager().createAccount(this.user, this.password);
                            conn.login(this.user, this.password, RESOURCE_NAME);
                            break block9;
                        }
                        catch (XMPPException createException) {
                            throw new JabberClientException("Can't create an account for user " + this.user + " on " + this.getHost(), createException);
                        }
                    }
                    throw new JabberClientException("Can't connect to " + this.getHost() + " with user " + this.user, e);
                }
            }
            try {
                conn.loginAnonymously();
            }
            catch (XMPPException e) {
                throw new JabberClientException("Can't open an anonymous session on " + this.getHost(), e);
            }
        }
    }

    public void logoff() throws JabberClientException {
        this.disconnect();
    }

    public void sendMessageToUser(String recipientUser, String message) throws JabberClientException {
        XMPPConnection conn = this.getConnection();
        try {
            conn.createChat(recipientUser).sendMessage(message);
        }
        catch (XMPPException e) {
            throw new JabberClientException("Can't send a message to " + recipientUser + " user", e);
        }
    }

    public void sendMessageToGroup(String recipientGroup, String message) throws JabberClientException {
        XMPPConnection conn = this.getConnection();
        try {
            conn.createGroupChat(recipientGroup).sendMessage(message);
        }
        catch (XMPPException e) {
            throw new JabberClientException("Can't send a message to " + recipientGroup + " group", e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        if (this.port != -1) {
            return this.port;
        }
        if (this.isSslConnection) {
            return 5223;
        }
        return 5222;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSslConnection() {
        return this.isSslConnection;
    }

    public void setSslConnection(boolean isSslConnection) {
        this.isSslConnection = isSslConnection;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

