/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.ircbot;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Iterator;
import org.codehaus.plexus.ircbot.IrcBot;
import org.codehaus.plexus.ircbot.botlet.Botlet;
import org.codehaus.plexus.ircbot.botlet.manager.BotletManager;
import org.codehaus.plexus.ircbot.botlet.manager.BotletNotFoundException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;

public class DefaultIrcBot
implements IrcBot,
Startable {
    private BufferedReader input;
    private BufferedWriter output;
    private Socket clientSocket;
    public boolean running;
    private int port;
    private String host;
    private String botName;
    private String botDescription;
    private String channel;
    private BotletManager botletManager;

    protected void connect(String serverHostname, int serverPort) {
        try {
            this.clientSocket = new Socket(serverHostname, serverPort);
        }
        catch (Exception e) {
            System.err.println("error connecting to IRC server");
            e.printStackTrace();
            System.exit(0);
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.clientSocket.getInputStream();
            outputStream = this.clientSocket.getOutputStream();
        }
        catch (Exception e) {
            System.err.println("error opening streams to IRC server");
            e.printStackTrace();
            System.exit(0);
        }
        this.input = new BufferedReader(new InputStreamReader(inputStream));
        this.output = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    protected void disconnect() {
        try {
            this.input.close();
            this.output.close();
        }
        catch (IOException e) {
            System.err.println("Error disconnecting from IRC server");
            e.printStackTrace();
        }
    }

    public boolean ircsend(String message) {
        System.out.println("irc: '" + message + "'");
        try {
            this.output.write(message);
            this.output.newLine();
            this.output.flush();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected void logoff() {
        BufferedWriter bw = this.output;
        try {
            if (!this.ircsend("quit terminating")) {
                // empty if block
            }
            bw.write("quit terminating");
            bw.newLine();
            bw.flush();
        }
        catch (Exception e) {
            System.out.println("logoff error: " + e);
            System.exit(0);
        }
    }

    protected void logon() {
        BufferedWriter bw = this.output;
        try {
            bw.write("user " + this.botName + " ware2 irc :" + this.botDescription);
            bw.newLine();
            bw.write("nick " + this.botName);
            bw.newLine();
            bw.flush();
        }
        catch (Exception e) {
            System.out.println("logon error: " + e);
            System.exit(0);
        }
    }

    private void parse_privmsg(String username, String params) {
        System.out.println("parse_privmsg passed '" + params + "' from '" + username + "'");
        String me = params.substring(0, params.indexOf(32));
        params = params.substring(params.indexOf(32) + 1);
        String message = params.substring(0, 1).equals(":") ? params.substring(1) : params.substring(0);
        this.srv_privmsg(username, message);
    }

    private boolean pingpong(String msg) throws IOException {
        if (msg.substring(0, 4).equalsIgnoreCase("ping")) {
            String pongmsg = "pong " + msg.substring(5);
            this.output.write(pongmsg);
            this.output.newLine();
            this.output.flush();
            System.out.println("ping pong");
            return true;
        }
        return false;
    }

    protected void send_notice(String username, String message) {
        String command = "notice " + username + " :" + message;
        this.ircsend(command);
    }

    protected void send_privmsg(String username, String message) {
        String command = "privmsg " + username + " :" + message;
        this.ircsend(command);
    }

    protected void service() {
        try {
            if (this.input.ready()) {
                String msg = this.input.readLine();
                if (!this.pingpong(msg)) {
                    String prefix = null;
                    String command = null;
                    String params = null;
                    if (msg.substring(0, 1).equals(":")) {
                        prefix = msg.substring(1, msg.indexOf(32));
                        msg = msg.substring(msg.indexOf(32) + 1);
                    }
                    command = msg.substring(0, msg.indexOf(32));
                    params = msg.substring(msg.indexOf(32) + 1);
                    System.out.println("prefix: '" + prefix + "' command: '" + command + "' params: '" + params + "'");
                    if (command.equalsIgnoreCase("privmsg")) {
                        String username = null;
                        username = prefix.indexOf(33) != -1 ? prefix.substring(0, prefix.indexOf("!")) : prefix;
                        this.parse_privmsg(username, params);
                    }
                }
            } else {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (IOException e) {
            System.out.println("error: " + e);
            System.exit(0);
        }
    }

    protected void srv_privmsg(String user, String text) {
        if (text.startsWith("!") && text.length() > 1) {
            String command = null;
            String commandText = null;
            int i = text.indexOf(" ");
            if (i > 1) {
                command = text.substring(1, i);
                commandText = text.substring(i + 1);
            } else {
                command = text.substring(1);
            }
            try {
                this.botletManager.lookup(command).handleCommand(this, this.channel, user, commandText);
            }
            catch (BotletNotFoundException e) {
                // empty catch block
            }
        }
        Iterator i = this.botletManager.getBotlets().values().iterator();
        while (i.hasNext()) {
            ((Botlet)i.next()).handleText(this, this.channel, user, text);
        }
    }

    public void start() throws Exception {
        this.connect(this.host, this.port);
        this.logon();
        this.ircsend("JOIN " + this.channel);
        this.running = true;
        while (this.running) {
            this.service();
        }
    }

    public void stop() throws Exception {
        this.running = false;
        this.logoff();
        this.disconnect();
    }
}

