/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.i18n;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.i18n.I18NTokenizer;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.StringUtils;
import sun.misc.SoftCache;

public class DefaultI18N
extends AbstractLogEnabled
implements I18N,
Initializable {
    private static final Object[] NO_ARGS = new Object[0];
    private HashMap bundles;
    private String[] bundleNames;
    private String defaultBundleName;
    private Locale defaultLocale = Locale.getDefault();
    private String defaultLanguage = Locale.getDefault().getLanguage();
    private String defaultCountry = Locale.getDefault().getCountry();

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getDefaultCountry() {
        return this.defaultCountry;
    }

    public String getDefaultBundleName() {
        return this.defaultBundleName;
    }

    public String[] getBundleNames() {
        return (String[])this.bundleNames.clone();
    }

    public ResourceBundle getBundle() {
        return this.getBundle(this.getDefaultBundleName(), (Locale)null);
    }

    public ResourceBundle getBundle(String string) {
        return this.getBundle(string, (Locale)null);
    }

    public ResourceBundle getBundle(String string, String string2) {
        return this.getBundle(string, this.getLocale(string2));
    }

    public ResourceBundle getBundle(String string, Locale locale) {
        Object object;
        Object object2;
        string = string == null ? this.getDefaultBundleName() : string.trim();
        try {
            object2 = ResourceBundle.getBundle(string).getClass().getSuperclass();
            object = ((Class)object2).getDeclaredField("cacheList");
            ((Field)object).setAccessible(true);
            SoftCache softCache = (SoftCache)((Field)object).get(null);
            softCache.clear();
            ((Field)object).setAccessible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (locale == null) {
            locale = this.getLocale(null);
        }
        object2 = null;
        object = (HashMap)this.bundles.get(string);
        if (object != null) {
            object2 = (ResourceBundle)((HashMap)object).get(locale);
            if (object2 == null) {
                object2 = this.cacheBundle(string, locale);
            }
        } else {
            object2 = this.cacheBundle(string, locale);
        }
        return object2;
    }

    public Locale getLocale(String string) {
        I18NTokenizer i18NTokenizer;
        if (!StringUtils.isEmpty((String)string) && (i18NTokenizer = new I18NTokenizer(string)).hasNext()) {
            return (Locale)i18NTokenizer.next();
        }
        return this.defaultLocale;
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, Locale locale) {
        return this.getString(this.getDefaultBundleName(), locale, string);
    }

    public String getString(String string, Locale locale, String string2) {
        String string3;
        ResourceBundle resourceBundle;
        String string4 = null;
        if (locale == null) {
            locale = this.getLocale(null);
        }
        if ((string4 = this.getStringOrNull(resourceBundle = this.getBundle(string, locale), string2)) == null && this.bundleNames.length > 0) {
            for (int i = 0; i < this.bundleNames.length; ++i) {
                string3 = this.bundleNames[i];
                if (string3.equals(string) || (string4 = this.getStringOrNull(resourceBundle = this.getBundle(string3, locale), string2)) == null) continue;
                locale = resourceBundle.getLocale();
                break;
            }
        }
        if (string4 == null) {
            string3 = locale.toString();
            String string5 = "Noticed missing resource: bundleName=" + string + ", locale=" + string3 + ", key=" + string2;
            this.getLogger().debug(string5);
            string4 = string2;
        }
        return string4;
    }

    public String format(String string, Object object) {
        return this.format(this.defaultBundleName, this.defaultLocale, string, new Object[]{object});
    }

    public String format(String string, Object object, Object object2) {
        return this.format(this.defaultBundleName, this.defaultLocale, string, new Object[]{object, object2});
    }

    public String format(String string, Locale locale, String string2, Object object) {
        return this.format(string, locale, string2, new Object[]{object});
    }

    public String format(String string, Locale locale, String string2, Object object, Object object2) {
        return this.format(string, locale, string2, new Object[]{object, object2});
    }

    public String format(String string, Locale locale, String string2, Object[] objectArray) {
        if (locale == null) {
            locale = this.getLocale(null);
        }
        String string3 = this.getString(string, locale, string2);
        if (objectArray == null) {
            objectArray = NO_ARGS;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(string3);
        return messageFormat.format(objectArray);
    }

    public void initialize() throws Exception {
        this.bundles = new HashMap();
        this.defaultLocale = new Locale(this.defaultLanguage, this.defaultCountry);
        this.initializeBundleNames();
    }

    protected void initializeBundleNames() {
        if (this.defaultBundleName != null && this.defaultBundleName.length() > 0) {
            if (this.bundleNames == null || this.bundleNames.length <= 0) {
                this.bundleNames = new String[]{this.defaultBundleName};
            } else {
                String[] stringArray = new String[this.bundleNames.length + 1];
                stringArray[0] = this.defaultBundleName;
                System.arraycopy(this.bundleNames, 0, stringArray, 1, this.bundleNames.length);
                this.bundleNames = stringArray;
            }
        }
        if (this.bundleNames == null) {
            this.bundleNames = new String[0];
        }
    }

    private synchronized ResourceBundle cacheBundle(String string, Locale locale) throws MissingResourceException {
        ResourceBundle resourceBundle;
        HashMap<Locale, ResourceBundle> hashMap = (HashMap<Locale, ResourceBundle>)this.bundles.get(string);
        ResourceBundle resourceBundle2 = resourceBundle = hashMap == null ? null : (ResourceBundle)hashMap.get(locale);
        if (resourceBundle == null) {
            block4: {
                hashMap = hashMap == null ? new HashMap<Locale, ResourceBundle>(3) : new HashMap(hashMap);
                try {
                    resourceBundle = ResourceBundle.getBundle(string, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    resourceBundle = this.findBundleByLocale(string, locale, hashMap);
                    if (resourceBundle != null) break block4;
                    throw (MissingResourceException)missingResourceException.fillInStackTrace();
                }
            }
            if (resourceBundle != null) {
                hashMap.put(resourceBundle.getLocale(), resourceBundle);
                HashMap<String, HashMap<Locale, ResourceBundle>> hashMap2 = new HashMap<String, HashMap<Locale, ResourceBundle>>(this.bundles);
                hashMap2.put(string, hashMap);
                this.bundles = hashMap2;
            }
        }
        return resourceBundle;
    }

    private ResourceBundle findBundleByLocale(String string, Locale locale, Map map) {
        Locale locale2;
        ResourceBundle resourceBundle = null;
        if (!StringUtils.isNotEmpty((String)locale.getCountry()) && this.defaultLanguage.equals(locale.getLanguage())) {
            Locale locale3 = new Locale(locale.getLanguage(), this.defaultCountry);
            resourceBundle = (ResourceBundle)map.get(locale3);
            if (resourceBundle == null) {
                resourceBundle = this.getBundleIgnoreException(string, locale3);
            }
        } else if (!StringUtils.isNotEmpty((String)locale.getLanguage()) && this.defaultCountry.equals(locale.getCountry()) && (resourceBundle = (ResourceBundle)map.get(locale2 = new Locale(this.defaultLanguage, locale.getCountry()))) == null) {
            resourceBundle = this.getBundleIgnoreException(string, locale2);
        }
        if (resourceBundle == null && !this.defaultLocale.equals(locale)) {
            resourceBundle = this.getBundleIgnoreException(string, this.defaultLocale);
        }
        return resourceBundle;
    }

    private final ResourceBundle getBundleIgnoreException(String string, Locale locale) {
        try {
            return ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    protected final String getStringOrNull(ResourceBundle resourceBundle, String string) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }
}

