/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.i18n;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.i18n.I18NTokenizer;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

public class DefaultI18N
extends AbstractLogEnabled
implements I18N,
Configurable,
Initializable {
    private static final Object[] NO_ARGS = new Object[0];
    private HashMap bundles;
    private String[] bundleNames;
    private String defaultBundleName;
    private Locale defaultLocale;
    private String defaultLanguage;
    private String defaultCountry;

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getDefaultCountry() {
        return this.defaultCountry;
    }

    public String getDefaultBundleName() {
        return this.defaultBundleName;
    }

    public String[] getBundleNames() {
        return (String[])this.bundleNames.clone();
    }

    public ResourceBundle getBundle() {
        return this.getBundle(this.getDefaultBundleName(), (Locale)null);
    }

    public ResourceBundle getBundle(String bundleName) {
        return this.getBundle(bundleName, (Locale)null);
    }

    public ResourceBundle getBundle(String bundleName, String languageHeader) {
        return this.getBundle(bundleName, this.getLocale(languageHeader));
    }

    public ResourceBundle getBundle(String bundleName, Locale locale) {
        String string = bundleName = bundleName == null ? this.getDefaultBundleName() : bundleName.trim();
        if (locale == null) {
            locale = this.getLocale(null);
        }
        ResourceBundle rb = null;
        HashMap bundlesByLocale = (HashMap)this.bundles.get(bundleName);
        if (bundlesByLocale != null) {
            rb = (ResourceBundle)bundlesByLocale.get(locale);
            if (rb == null) {
                rb = this.cacheBundle(bundleName, locale);
            }
        } else {
            rb = this.cacheBundle(bundleName, locale);
        }
        return rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBundle(String defaultBundle) {
        if (this.bundleNames.length > 0) {
            this.bundleNames[0] = defaultBundle;
        } else {
            DefaultI18N defaultI18N = this;
            synchronized (defaultI18N) {
                if (this.bundleNames.length <= 0) {
                    this.bundleNames = new String[]{defaultBundle};
                }
            }
        }
    }

    public Locale getLocale(String header) {
        I18NTokenizer tok;
        if (!StringUtils.isEmpty((String)header) && (tok = new I18NTokenizer(header)).hasNext()) {
            return (Locale)tok.next();
        }
        return this.defaultLocale;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, Locale locale) {
        return this.getString(this.getDefaultBundleName(), locale, key);
    }

    public String getString(String bundleName, Locale locale, String key) {
        ResourceBundle rb;
        String value = null;
        if (locale == null) {
            locale = this.getLocale(null);
        }
        if ((value = this.getStringOrNull(rb = this.getBundle(bundleName, locale), key)) == null && this.bundleNames.length > 0) {
            int i = 0;
            while (i < this.bundleNames.length) {
                String name = this.bundleNames[i];
                if (!name.equals(bundleName) && (value = this.getStringOrNull(rb = this.getBundle(name, locale), key)) != null) {
                    locale = rb.getLocale();
                    break;
                }
                ++i;
            }
        }
        if (value == null) {
            String loc = locale.toString();
            String mesg = "Noticed missing resource: bundleName=" + bundleName + ", locale=" + loc + ", key=" + key;
            this.getLogger().debug(mesg);
            throw new MissingResourceException(mesg, bundleName, key);
        }
        return value;
    }

    public String format(String bundleName, Locale locale, String key, Object arg1) {
        return this.format(bundleName, locale, key, new Object[]{arg1});
    }

    public String format(String bundleName, Locale locale, String key, Object arg1, Object arg2) {
        return this.format(bundleName, locale, key, new Object[]{arg1, arg2});
    }

    public String format(String bundleName, Locale locale, String key, Object[] args) {
        if (locale == null) {
            locale = this.getLocale(null);
        }
        String value = this.getString(bundleName, locale, key);
        if (args == null) {
            args = NO_ARGS;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(value);
        return messageFormat.format(args);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Locale jvmDefault = Locale.getDefault();
        this.defaultLanguage = configuration.getChild("default-language").getValue(jvmDefault.getLanguage());
        this.defaultCountry = configuration.getChild("default-country").getValue(jvmDefault.getCountry());
        this.defaultBundleName = configuration.getChild("default-bundle-name").getValue(null);
    }

    public void initialize() throws Exception {
        this.bundles = new HashMap();
        this.defaultLocale = new Locale(this.defaultLanguage, this.defaultCountry);
        this.initializeBundleNames(null);
    }

    protected void initializeBundleNames(String[] ignored) {
        if (this.defaultBundleName != null && this.defaultBundleName.length() > 0) {
            if (this.bundleNames == null || this.bundleNames.length <= 0) {
                this.bundleNames = new String[]{this.defaultBundleName};
            } else {
                String[] array = new String[this.bundleNames.length + 1];
                array[0] = this.defaultBundleName;
                System.arraycopy(this.bundleNames, 0, array, 1, this.bundleNames.length);
                this.bundleNames = array;
            }
        }
        if (this.bundleNames == null) {
            this.bundleNames = new String[0];
        }
    }

    private synchronized ResourceBundle cacheBundle(String bundleName, Locale locale) throws MissingResourceException {
        ResourceBundle rb;
        HashMap<Locale, ResourceBundle> bundlesByLocale = (HashMap<Locale, ResourceBundle>)this.bundles.get(bundleName);
        ResourceBundle resourceBundle = rb = bundlesByLocale == null ? null : (ResourceBundle)bundlesByLocale.get(locale);
        if (rb == null) {
            block4: {
                bundlesByLocale = bundlesByLocale == null ? new HashMap<Locale, ResourceBundle>(3) : new HashMap(bundlesByLocale);
                try {
                    rb = ResourceBundle.getBundle(bundleName, locale);
                }
                catch (MissingResourceException e) {
                    rb = this.findBundleByLocale(bundleName, locale, bundlesByLocale);
                    if (rb != null) break block4;
                    throw (MissingResourceException)e.fillInStackTrace();
                }
            }
            if (rb != null) {
                bundlesByLocale.put(rb.getLocale(), rb);
                HashMap<String, HashMap<Locale, ResourceBundle>> bundlesByName = new HashMap<String, HashMap<Locale, ResourceBundle>>(this.bundles);
                bundlesByName.put(bundleName, bundlesByLocale);
                this.bundles = bundlesByName;
            }
        }
        return rb;
    }

    private ResourceBundle findBundleByLocale(String bundleName, Locale locale, Map bundlesByLocale) {
        Locale withDefaultLanguage;
        ResourceBundle rb = null;
        if (!StringUtils.isNotEmpty((String)locale.getCountry()) && this.defaultLanguage.equals(locale.getLanguage())) {
            Locale withDefaultCountry = new Locale(locale.getLanguage(), this.defaultCountry);
            rb = (ResourceBundle)bundlesByLocale.get(withDefaultCountry);
            if (rb == null) {
                rb = this.getBundleIgnoreException(bundleName, withDefaultCountry);
            }
        } else if (!StringUtils.isNotEmpty((String)locale.getLanguage()) && this.defaultCountry.equals(locale.getCountry()) && (rb = (ResourceBundle)bundlesByLocale.get(withDefaultLanguage = new Locale(this.defaultLanguage, locale.getCountry()))) == null) {
            rb = this.getBundleIgnoreException(bundleName, withDefaultLanguage);
        }
        if (rb == null && !this.defaultLocale.equals(locale)) {
            rb = this.getBundleIgnoreException(bundleName, this.defaultLocale);
        }
        return rb;
    }

    private final ResourceBundle getBundleIgnoreException(String bundleName, Locale locale) {
        try {
            return ResourceBundle.getBundle(bundleName, locale);
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    protected final String getStringOrNull(ResourceBundle rb, String key) {
        if (rb != null) {
            try {
                return rb.getString(key);
            }
            catch (MissingResourceException ignored) {
            }
        }
        return null;
    }
}

