/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.formica.validation;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.codehaus.plexus.formica.validation.AbstractValidator;

public class DateValidator
extends AbstractValidator {
    private String pattern;
    private boolean strict = true;

    public boolean validate(String value) {
        if (value == null || this.pattern == null || this.pattern.length() <= 0) {
            return false;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(this.pattern);
        formatter.setLenient(false);
        try {
            formatter.parse(value);
        }
        catch (ParseException e) {
            return false;
        }
        return !this.strict || this.pattern.length() == value.length();
    }

    public boolean isValid(String value, Locale locale) {
        if (value == null) {
            return false;
        }
        DateFormat formatter = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3, Locale.getDefault());
        formatter.setLenient(false);
        try {
            formatter.parse(value);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

