/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.formica.util;

import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import sun.misc.BASE64Encoder;

public class MungedHttpsURL {
    private String urlString;
    private String username;
    private String password;

    public MungedHttpsURL(String mungedUrl) throws MalformedURLException {
        this.username = this.scrapeUsername(mungedUrl);
        this.password = this.scrapePassword(mungedUrl);
        this.urlString = this.scrapeUrl(mungedUrl);
        if (this.urlString == null) {
            throw new MalformedURLException("Unable to generate clean url from url string: " + mungedUrl);
        }
    }

    public MungedHttpsURL(String urlString, String username, String password) throws MalformedURLException {
        this.username = username;
        this.password = password;
        this.urlString = urlString;
        if (!this.isValid()) {
            throw new MalformedURLException("Unable to validate URL");
        }
    }

    public boolean isValid() {
        try {
            URL url = this.getURL();
            InputStream is = url.openStream();
            is.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public URL getURL() throws MalformedURLException {
        try {
            if (this.urlString.startsWith("https")) {
                return this.getHttpsUrl();
            }
            return this.getHttpUrl();
        }
        catch (Exception e) {
            throw new MalformedURLException("unable to create munged url");
        }
    }

    private URL getHttpUrl() throws MalformedURLException {
        if (this.username != null && this.password != null) {
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    PasswordAuthentication passwordAuthentication = new PasswordAuthentication(MungedHttpsURL.this.username, MungedHttpsURL.this.password.toCharArray());
                    return passwordAuthentication;
                }
            });
        }
        return new URL(this.urlString);
    }

    private URL getHttpsUrl() throws Exception {
        this.ignoreCertificates();
        String authString = this.username + ":" + this.password;
        URL url = new URL(this.urlString);
        HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
        urlc.setDoInput(true);
        urlc.setUseCaches(false);
        urlc.setRequestProperty("Content-Type", "application/octet-stream");
        if (this.username != null && this.password != null) {
            urlc.setRequestProperty("Authorization", "Basic " + new BASE64Encoder().encode(authString.getBytes()));
        }
        return url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrlString() {
        return this.urlString;
    }

    private void ignoreCertificates() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
    }

    private String scrapeUsername(String url) {
        String t = url.substring(url.lastIndexOf(47) + 1, url.length());
        if (t.indexOf(":") < 0 && t.indexOf("@") < 0) {
            return null;
        }
        return t.substring(0, t.indexOf(":"));
    }

    private String scrapePassword(String url) {
        String t = url.substring(url.lastIndexOf(47) + 1, url.length());
        if (t.indexOf(":") < 0 && t.indexOf("@") < 0) {
            return null;
        }
        return t.substring(t.indexOf(":") + 1, t.indexOf("@"));
    }

    private String scrapeUrl(String url) {
        if (url.indexOf("@") != -1) {
            String s = url.substring(url.indexOf("@") + 1, url.length());
            if (url.startsWith("http://")) {
                return "http://" + s;
            }
            return "https://" + s;
        }
        return url;
    }
}

