/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.formica.validation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.oro.text.perl.Perl5Util;
import org.codehaus.plexus.formica.validation.AbstractValidator;

public class UrlValidator
extends AbstractValidator {
    public static int ALLOW_ALL_SCHEMES = 1;
    private static String ALPHA_CHARS = "a-zA-Z";
    private static String ALPHA_NUMERIC_CHARS = ALPHA_CHARS + "\\d";
    private static String SPECIAL_CHARS = ";/@&=,.?:+$";
    private static String VALID_CHARS = "[^\\s" + SPECIAL_CHARS + "]";
    private static String SCHEME_CHARS = ALPHA_CHARS;
    private static String AUTHORITY_CHARS = ALPHA_NUMERIC_CHARS + "\\-\\.";
    private static String ATOM = VALID_CHARS + '+';
    private static String URL_PATTERN = "/^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?/";
    private static int PARSE_URL_SCHEME = 2;
    private static int PARSE_URL_AUTHORITY = 4;
    private static int PARSE_URL_PATH = 5;
    private static int PARSE_URL_QUERY = 7;
    private static int PARSE_URL_FRAGMENT = 9;
    private static String SCHEME_PATTERN = "/^[" + SCHEME_CHARS + "]/";
    private static String AUTHORITY_PATTERN = "/^([" + AUTHORITY_CHARS + "]*)(:\\d*)?(.*)?/";
    private static int PARSE_AUTHORITY_HOST_IP = 1;
    private static int PARSE_AUTHORITY_PORT = 2;
    private static int PARSE_AUTHORITY_EXTRA = 3;
    private static String PATH_PATTERN = "/^(/[-a-zA-Z0-9_:@&?=+,.!/~*'%$]*)$/";
    private static String QUERY_PATTERN = "/^(.*)$/";
    private static String LEGAL_ASCII_PATTERN = "/^[\\000-\\177]+$/";
    private static String IP_V4_DOMAIN_PATTERN = "/^(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})$/";
    private static String DOMAIN_PATTERN = "/^" + ATOM + "(\\." + ATOM + ")*$/";
    private static String PORT_PATTERN = "/^:(\\d{1,5})$/";
    private static String ATOM_PATTERN = "/(" + ATOM + ")/";
    private static String ALPHA_PATTERN = "/^[" + ALPHA_CHARS + "]/";
    private Set allowedSchemes = new HashSet();
    protected String[] defaultSchemes = new String[]{"http", "https", "ftp"};

    public UrlValidator() {
        this(null);
    }

    public UrlValidator(String[] schemes) {
        this(schemes, 0);
    }

    public UrlValidator(int options) {
        this(null, options);
    }

    public UrlValidator(String[] schemes, int options) {
        if (schemes == null) {
            schemes = this.defaultSchemes;
        }
        this.allowedSchemes.addAll(Arrays.asList(schemes));
    }

    public boolean validate(String value) {
        if (value == null) {
            return false;
        }
        Perl5Util matchUrlPat = new Perl5Util();
        Perl5Util matchAsciiPat = new Perl5Util();
        if (!matchAsciiPat.match(LEGAL_ASCII_PATTERN, value)) {
            return false;
        }
        if (!matchUrlPat.match(URL_PATTERN, value)) {
            return false;
        }
        if (!this.isValidScheme(matchUrlPat.group(PARSE_URL_SCHEME))) {
            return false;
        }
        if (!this.isValidAuthority(matchUrlPat.group(PARSE_URL_AUTHORITY))) {
            return false;
        }
        if (!this.isValidPath(matchUrlPat.group(PARSE_URL_PATH))) {
            return false;
        }
        if (!this.isValidQuery(matchUrlPat.group(PARSE_URL_QUERY))) {
            return false;
        }
        return this.isValidFragment(matchUrlPat.group(PARSE_URL_FRAGMENT));
    }

    protected boolean isValidScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        Perl5Util schemeMatcher = new Perl5Util();
        return schemeMatcher.match(SCHEME_PATTERN, scheme);
    }

    protected boolean isValidAuthority(String authority) {
        Perl5Util portMatcher;
        if (authority == null) {
            return false;
        }
        Perl5Util authorityMatcher = new Perl5Util();
        Perl5Util matchIPV4Pat = new Perl5Util();
        if (!authorityMatcher.match(AUTHORITY_PATTERN, authority)) {
            return false;
        }
        boolean hostname = false;
        String hostIP = authorityMatcher.group(PARSE_AUTHORITY_HOST_IP);
        boolean ipV4Address = matchIPV4Pat.match(IP_V4_DOMAIN_PATTERN, hostIP);
        if (ipV4Address) {
            for (int i = 1; i <= 4; ++i) {
                String ipSegment = matchIPV4Pat.group(i);
                if (ipSegment == null || ipSegment.length() <= 0) {
                    return false;
                }
                try {
                    if (Integer.parseInt(ipSegment) <= 255) continue;
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        } else {
            Perl5Util domainMatcher = new Perl5Util();
            hostname = domainMatcher.match(DOMAIN_PATTERN, hostIP);
        }
        if (hostname) {
            String[] domainSegment = new String[10];
            boolean match = true;
            int segmentCount = 0;
            Perl5Util atomMatcher = new Perl5Util();
            while (match) {
                match = atomMatcher.match(ATOM_PATTERN, hostIP);
                if (!match) continue;
                domainSegment[segmentCount] = atomMatcher.group(1);
                int segmentLength = domainSegment[segmentCount].length() + 1;
                hostIP = segmentLength >= hostIP.length() ? "" : hostIP.substring(segmentLength);
                ++segmentCount;
            }
            String topLevel = domainSegment[segmentCount - 1];
            if (topLevel.length() < 2 || topLevel.length() > 4) {
                return false;
            }
            Perl5Util alphaMatcher = new Perl5Util();
            if (!alphaMatcher.match(ALPHA_PATTERN, topLevel.substring(0, 1))) {
                return false;
            }
            if (segmentCount < 2) {
                return false;
            }
        }
        if (!hostname && !ipV4Address) {
            return false;
        }
        String port = authorityMatcher.group(PARSE_AUTHORITY_PORT);
        if (port != null && !(portMatcher = new Perl5Util()).match(PORT_PATTERN, port)) {
            return false;
        }
        String extra = authorityMatcher.group(PARSE_AUTHORITY_EXTRA);
        return this.isBlankOrNull(extra);
    }

    protected boolean isBlankOrNull(String s) {
        return s == null || s.trim().length() == 0;
    }

    protected boolean isValidPath(String path) {
        if (path == null) {
            return false;
        }
        Perl5Util pathMatcher = new Perl5Util();
        if (!pathMatcher.match(PATH_PATTERN, path)) {
            return false;
        }
        if (path.endsWith("/")) {
            return false;
        }
        int slash2Count = this.countToken("//", path);
        int slashCount = this.countToken("/", path);
        int dot2Count = this.countToken("..", path);
        return dot2Count <= 0 || slashCount - slash2Count - 1 > dot2Count;
    }

    protected boolean isValidQuery(String query) {
        if (query == null) {
            return true;
        }
        Perl5Util queryMatcher = new Perl5Util();
        return queryMatcher.match(QUERY_PATTERN, query);
    }

    protected boolean isValidFragment(String fragment) {
        if (fragment == null) {
            return true;
        }
        return true;
    }

    protected int countToken(String token, String target) {
        int tokenIndex = 0;
        int count = 0;
        while (tokenIndex != -1) {
            if ((tokenIndex = target.indexOf(token, tokenIndex)) <= -1) continue;
            ++tokenIndex;
            ++count;
        }
        return count;
    }
}

