/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.formica;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.formica.Element;
import org.codehaus.plexus.formica.ElementGroup;
import org.codehaus.plexus.formica.Form;
import org.codehaus.plexus.formica.FormManager;
import org.codehaus.plexus.formica.FormNotFoundException;
import org.codehaus.plexus.formica.FormicaException;
import org.codehaus.plexus.formica.Validator;
import org.codehaus.plexus.formica.population.Populator;
import org.codehaus.plexus.formica.population.TargetPopulationException;
import org.codehaus.plexus.formica.validation.FormValidationResult;
import org.codehaus.plexus.formica.validation.group.GroupValidator;
import org.codehaus.plexus.formica.validation.manager.ValidatorManager;
import org.codehaus.plexus.formica.validation.manager.ValidatorNotFoundException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

public class DefaultFormManager
extends AbstractLogEnabled
implements FormManager,
Initializable {
    private Map formMap;
    private Populator populator;
    private I18N i18n;
    private ValidatorManager validatorManager;
    private Map groupValidatorMap;
    private List forms;

    public void addForm(Form form) {
        this.forms.add(form);
        this.formMap.put(form.getId(), form);
    }

    public org.codehaus.plexus.formica.validation.Validator getValidator(String validatorId) throws ValidatorNotFoundException {
        return this.validatorManager.getValidator(validatorId);
    }

    public GroupValidator getGroupValidator(String groupValidatorId) {
        if (this.groupValidatorMap.containsKey(groupValidatorId)) {
            return (GroupValidator)this.groupValidatorMap.get(groupValidatorId);
        }
        return null;
    }

    public Form getForm(String formId) throws FormNotFoundException {
        Form form = (Form)this.formMap.get(formId);
        if (form == null) {
            throw new FormNotFoundException("The form with the id " + formId + " cannot be found.");
        }
        return form;
    }

    public FormValidationResult validate(String formId, Map data) throws FormicaException, FormNotFoundException, ValidatorNotFoundException {
        return this.validate(this.getForm(formId), data);
    }

    public FormValidationResult validate(Form form, Map data) throws FormicaException, ValidatorNotFoundException {
        FormValidationResult result = new FormValidationResult();
        if (form.getElements() != null) {
            this.validateElements(form.getElements(), data, result);
        }
        if (form.getElementGroups() != null) {
            this.validateElementGroups(form, data, result);
        }
        return result;
    }

    private void validateElementGroups(Form form, Map data, FormValidationResult result) throws FormicaException, ValidatorNotFoundException {
        Iterator i = form.getElementGroups().iterator();
        while (i.hasNext()) {
            ElementGroup group = (ElementGroup)i.next();
            GroupValidator validator = this.getGroupValidator(group.getValidator());
            boolean valid = validator.validate(group, data);
            String errorMessage = null;
            if (!valid) {
                errorMessage = this.i18n.getString(group.getErrorMessageKey());
            }
            result.addElementValidationResult(group.getId(), valid, errorMessage);
            this.validateElements(group.getElements(), data, result);
        }
    }

    private void validateElements(List elements, Map data, FormValidationResult result) throws ValidatorNotFoundException, FormicaException {
        Iterator i = elements.iterator();
        block0: while (i.hasNext()) {
            Element element = (Element)i.next();
            List validators = element.getValidators();
            Iterator j = validators.iterator();
            while (j.hasNext()) {
                String elementData;
                Validator v = (Validator)j.next();
                org.codehaus.plexus.formica.validation.Validator validator = this.getValidator(v.getId());
                boolean valid = validator.validate(elementData = (String)data.get(element.getId()));
                if (valid) {
                    result.addElementValidationResult(element.getId(), valid, null);
                    continue;
                }
                result.addElementValidationResult(element.getId(), valid, this.i18n.getString(v.getErrorMessageKey()));
                continue block0;
            }
        }
    }

    public void populate(Form form, Map data, Object target) throws TargetPopulationException {
        this.populator.populate(form, data, target);
    }

    public Object populate(String formId, Map data, ClassLoader classLoader) throws TargetPopulationException, FormNotFoundException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Form form = this.getForm(formId);
        Object target = classLoader.loadClass(form.getTargetClass()).newInstance();
        this.populator.populate(form, data, target);
        return target;
    }

    public void populate(String formId, Map data, Object target) throws TargetPopulationException, FormNotFoundException {
        this.populator.populate(this.getForm(formId), data, target);
    }

    public void initialize() throws Exception {
        Form form;
        this.formMap = new HashMap();
        Iterator i = this.forms.iterator();
        while (i.hasNext()) {
            form = (Form)i.next();
            this.formMap.put(form.getId(), form);
        }
        i = this.forms.iterator();
        while (i.hasNext()) {
            form = (Form)i.next();
            if (form.getExtend() == null) continue;
            LinkedList lineage = new LinkedList();
            this.assembleLineage(form, lineage);
            for (int j = 0; j < lineage.size() - 1; ++j) {
                this.assembleInheritance((Form)lineage.get(j), (Form)lineage.get(j + 1));
            }
            form.setExtend(null);
        }
    }

    private void assembleLineage(Form form, LinkedList lineage) {
        lineage.addFirst(form);
        if (form.getExtend() != null) {
            this.assembleLineage((Form)this.formMap.get(form.getExtend()), lineage);
        }
    }

    private void assembleInheritance(Form parent, Form child) {
        if (child.getKeyExpression() == null) {
            child.setKeyExpression(parent.getKeyExpression());
        }
        if (child.getLookupExpression() == null) {
            child.setLookupExpression(parent.getLookupExpression());
        }
        if (child.getSummaryCollectionExpression() == null) {
            child.setSummaryCollectionExpression(parent.getSummaryCollectionExpression());
        }
        if (child.getSourceRole() == null) {
            child.setSourceRole(parent.getSourceRole());
        }
        if (child.getAdd() == null) {
            child.setAdd(parent.getAdd());
        }
        if (child.getUpdate() == null) {
            child.setUpdate(parent.getUpdate());
        }
        if (child.getView() == null) {
            child.setView(parent.getView());
        }
        if (child.getDelete() == null) {
            child.setDelete(parent.getDelete());
        }
        Iterator i = parent.getElements().iterator();
        while (i.hasNext()) {
            Element parentElement = (Element)i.next();
            if (child.getElement(parentElement.getId()) != null) continue;
            child.addElement(parentElement);
        }
    }
}

