/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository.io;

import java.io.Reader;
import java.io.StringReader;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public class PlexusTools {
    public static ComponentDescriptor buildComponentDescriptor(String configuration) throws Exception {
        return PlexusTools.buildComponentDescriptor(PlexusTools.buildConfiguration(configuration));
    }

    public static ComponentDescriptor buildComponentDescriptor(PlexusConfiguration configuration) throws Exception {
        ComponentDescriptor cd = new ComponentDescriptor();
        cd.setRole(configuration.getChild("role").getValue());
        cd.setRoleHint(configuration.getChild("role-hint").getValue());
        cd.setImplementation(configuration.getChild("implementation").getValue());
        cd.setVersion(configuration.getChild("version").getValue());
        cd.setComponentType(configuration.getChild("component-type").getValue());
        cd.setInstantiationStrategy(configuration.getChild("instantiation-strategy").getValue());
        cd.setLifecycleHandler(configuration.getChild("lifecycle-handler").getValue());
        cd.setComponentProfile(configuration.getChild("component-profile").getValue());
        cd.setComponentComposer(configuration.getChild("component-composer").getValue());
        cd.setComponentFactory(configuration.getChild("component-factory").getValue());
        cd.setDescription(configuration.getChild("description").getValue());
        cd.setAlias(configuration.getChild("alias").getValue());
        String s = configuration.getChild("isolated-realm").getValue();
        if (s != null) {
            cd.setIsolatedRealm(s.equals("true"));
        }
        cd.setConfiguration(configuration.getChild("configuration"));
        PlexusConfiguration[] requirements = configuration.getChild("requirements").getChildren("requirement");
        int i = 0;
        while (i < requirements.length) {
            PlexusConfiguration requirement = requirements[i];
            ComponentRequirement cr = new ComponentRequirement();
            cr.setRole(requirement.getChild("role").getValue());
            cr.setRoleHint(requirement.getChild("role-hint").getValue());
            cr.setFieldName(requirement.getChild("field-name").getValue());
            cd.addRequirement(cr);
            ++i;
        }
        return cd;
    }

    public static ComponentSetDescriptor buildComponentSet(PlexusConfiguration c) throws Exception {
        ComponentSetDescriptor csd = new ComponentSetDescriptor();
        PlexusConfiguration[] components = c.getChild("components").getChildren("component");
        int i = 0;
        while (i < components.length) {
            PlexusConfiguration component = components[i];
            csd.addComponentDescriptor(PlexusTools.buildComponentDescriptor(component));
            ++i;
        }
        PlexusConfiguration[] dependencies = c.getChild("dependencies").getChildren("dependency");
        int i2 = 0;
        while (i2 < dependencies.length) {
            PlexusConfiguration d = dependencies[i2];
            ComponentDependency cd = new ComponentDependency();
            cd.setArtifactId(d.getChild("artifact-id").getValue());
            cd.setGroupId(d.getChild("group-id").getValue());
            String type = d.getChild("type").getValue();
            if (type != null) {
                cd.setType(type);
            }
            cd.setVersion(d.getChild("version").getValue());
            csd.addDependency(cd);
            ++i2;
        }
        return csd;
    }

    public static PlexusConfiguration buildConfiguration(Reader configuration) throws Exception {
        return new XmlPlexusConfiguration(Xpp3DomBuilder.build(configuration));
    }

    public static PlexusConfiguration buildConfiguration(String configuration) throws Exception {
        return PlexusTools.buildConfiguration(new StringReader(configuration));
    }
}

