/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters;

import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractConfigurationConverter
implements ConfigurationConverter {
    private static final String IMPLEMENTATION = "implementation";

    public abstract boolean canConvert(Class var1);

    public abstract Object fromConfiguration(ConverterLookup var1, PlexusConfiguration var2, Class var3, Class var4, ClassLoader var5) throws ComponentConfigurationException;

    protected String fromXML(String elementName) {
        return StringUtils.lowercaseFirstLetter(StringUtils.removeAndHump(elementName, "-"));
    }

    protected Class getClassForImplementationHint(Class type, PlexusConfiguration configuration, ClassLoader classLoader) throws ComponentConfigurationException {
        Class<?> retValue = type;
        String implementation = configuration.getAttribute(IMPLEMENTATION, null);
        if (implementation != null) {
            try {
                retValue = classLoader.loadClass(implementation);
            }
            catch (ClassNotFoundException e) {
                String msg = "Class name which was explicitly given in configuration using 'implementation' attribute: '" + implementation + "' cannot be loaded: " + e.getMessage();
                throw new ComponentConfigurationException(msg);
            }
        }
        return retValue;
    }

    protected Object instantiateObject(Class clazz) throws ComponentConfigurationException {
        Object retValue = null;
        try {
            retValue = clazz.newInstance();
            return retValue;
        }
        catch (Exception exception) {
            String msg = "Class '" + clazz.getName() + "' cannot be instantiated";
            throw new ComponentConfigurationException(msg);
        }
    }

    protected Object instantiateObject(String classname, ClassLoader classLoader) throws ComponentConfigurationException {
        Class clazz = this.loadClass(classname, classLoader);
        Object retValue = this.instantiateObject(clazz);
        return retValue;
    }

    protected Class loadClass(String classname, ClassLoader classLoader) throws ComponentConfigurationException {
        Class<?> retValue = null;
        try {
            retValue = classLoader.loadClass(classname);
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("Error loading class '" + classname + "'", e);
        }
        return retValue;
    }

    protected String toXML(String fieldName) {
        return StringUtils.addAndDeHump(fieldName);
    }
}

