/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.FileReader;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;

public class PlexusContainerHost
implements Runnable {
    private DefaultPlexusContainer container;
    private boolean shouldStop;
    private boolean isStopped;
    private Object shutdownSignal = new Object();

    protected void customizeContainer(PlexusContainer container) {
        container.addContextValue("plexus.home", System.getProperty("plexus.home"));
        container.addContextValue("plexus.work", String.valueOf(System.getProperty("plexus.home")) + "/work");
        container.addContextValue("plexus.logs", String.valueOf(System.getProperty("plexus.home")) + "/logs");
    }

    protected DefaultPlexusContainer getPlexusContainer() {
        return new DefaultPlexusContainer();
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public static void main(String[] args, ClassWorld classWorld) {
        if (args.length != 1) {
            System.err.println("usage: plexus <plexus.conf>");
            System.exit(1);
        }
        try {
            PlexusContainerHost host = new PlexusContainerHost();
            host.start(classWorld, args[0]);
            host.waitForContainerShutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        PlexusContainerHost plexusContainerHost = this;
        synchronized (plexusContainerHost) {
            while (!this.shouldStop) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        plexusContainerHost = this;
        synchronized (plexusContainerHost) {
            this.isStopped = true;
            this.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() throws Exception {
        PlexusContainerHost plexusContainerHost = this;
        synchronized (plexusContainerHost) {
            this.shouldStop = true;
            this.container.dispose();
            this.notifyAll();
        }
        plexusContainerHost = this;
        synchronized (plexusContainerHost) {
            while (true) {
                if (this.isStopped()) {
                    Object object = this.shutdownSignal;
                    synchronized (object) {
                        this.shutdownSignal.notifyAll();
                        break;
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    public PlexusContainer start(ClassWorld classWorld, String configurationResource) throws Exception {
        this.container = this.getPlexusContainer();
        this.container.setClassWorld(classWorld);
        this.container.setConfigurationResource(new FileReader(configurationResource));
        this.customizeContainer(this.container);
        File plexusLogs = new File(String.valueOf(System.getProperty("plexus.home")) + "/logs");
        if (!plexusLogs.exists()) {
            plexusLogs.mkdirs();
        }
        this.container.initialize();
        this.container.start();
        Thread thread = new Thread(this);
        thread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    PlexusContainerHost.this.shutdown();
                }
                catch (Exception exception) {}
            }
        }));
        thread.start();
        return this.container;
    }

    public void waitForContainerShutdown() {
        while (!this.isStopped()) {
            try {
                Object object = this.shutdownSignal;
                synchronized (object) {
                    this.shutdownSignal.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

