/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.composition.ComponentComposerManager;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.discovery.DiscoveryListenerDescriptor;
import org.codehaus.plexus.component.factory.ComponentFactory;
import org.codehaus.plexus.component.factory.ComponentFactoryManager;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.manager.ComponentManagerManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfigurationMerger;
import org.codehaus.plexus.configuration.PlexusConfigurationResourceException;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessor;
import org.codehaus.plexus.configuration.processor.DirectoryConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.FileConfigurationResourceHandler;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.lifecycle.LifecycleHandlerManager;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLoggerManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.InterpolationFilterReader;

public class DefaultPlexusContainer
extends AbstractLogEnabled
implements PlexusContainer {
    private PlexusContainer parentContainer;
    private LoggerManager loggerManager;
    private DefaultContext context = new DefaultContext();
    protected PlexusConfiguration configuration;
    private Reader configurationReader;
    private ClassWorld classWorld;
    private ClassRealm coreRealm;
    private ClassRealm plexusRealm;
    private String name;
    private ComponentRepository componentRepository;
    private ComponentManagerManager componentManagerManager;
    private LifecycleHandlerManager lifecycleHandlerManager;
    private ComponentDiscovererManager componentDiscovererManager;
    private ComponentFactoryManager componentFactoryManager;
    private ComponentComposerManager componentComposerManager;
    private Map realmAliases;
    public static final String BOOTSTRAP_CONFIGURATION = "org/codehaus/plexus/plexus-bootstrap.xml";
    static /* synthetic */ Class class$org$codehaus$plexus$PlexusContainer;

    public DefaultPlexusContainer() {
        this.loggerManager = new ConsoleLoggerManager("debug");
        this.enableLogging(this.loggerManager.getLoggerForComponent((class$org$codehaus$plexus$PlexusContainer != null ? class$org$codehaus$plexus$PlexusContainer : (class$org$codehaus$plexus$PlexusContainer = DefaultPlexusContainer.class$("org.codehaus.plexus.PlexusContainer"))).getName()));
    }

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentRepositoryException {
        this.componentRepository.addComponentDescriptor(componentDescriptor);
    }

    public void addContextValue(Object key, Object value) {
        this.context.put(key, value);
    }

    public void addJarRepository(File repository) throws Exception {
        if (repository.exists() && repository.isDirectory()) {
            File[] jars = repository.listFiles();
            int j = 0;
            while (j < jars.length) {
                if (jars[j].getAbsolutePath().endsWith(".jar")) {
                    this.addJarResource(jars[j]);
                }
                ++j;
            }
        } else {
            this.getLogger().warn("The specified JAR repository doesn't exist or is not a directory: '" + repository.getAbsolutePath() + "'.");
        }
    }

    public void addJarResource(File jar) throws Exception {
        this.plexusRealm.addConstituent(jar.toURL());
    }

    protected void addRealmAlias(String alias, String realmId) {
        this.realmAliases.put(alias, realmId);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void composeComponent(Object component, ComponentDescriptor componentDescriptor) throws Exception {
        this.componentComposerManager.assembleComponent(component, componentDescriptor, this);
    }

    public Object createComponentInstance(ComponentDescriptor componentDescriptor) throws Exception {
        String componentFactoryId = componentDescriptor.getComponentFactory();
        ComponentFactory componentFactory = null;
        componentFactory = componentFactoryId != null ? this.componentFactoryManager.findComponentFactory(componentFactoryId) : this.componentFactoryManager.getDefaultComponentFactory();
        return componentFactory.newInstance(componentDescriptor, this.plexusRealm, this);
    }

    private ComponentManager createComponentManager(ComponentDescriptor descriptor) throws ComponentLookupException {
        ComponentManager componentManager;
        try {
            componentManager = this.componentManagerManager.createComponentManager(descriptor, this);
        }
        catch (Exception e) {
            String message = "Cannot create component manager for " + descriptor.getComponentKey() + ", so we cannot provide a component instance.";
            this.getLogger().error(message, e);
            throw new ComponentLookupException(message, e);
        }
        return componentManager;
    }

    public List discoverComponents(ClassRealm classRealm) throws Exception {
        ArrayList<ComponentDescriptor> discoveredComponentDescriptors = new ArrayList<ComponentDescriptor>();
        Iterator i = this.componentDiscovererManager.getComponentDiscoverers().iterator();
        while (i.hasNext()) {
            ComponentDiscoverer componentDiscoverer = (ComponentDiscoverer)i.next();
            List componentSetDescriptors = componentDiscoverer.findComponents(this.getContext(), classRealm);
            Iterator j = componentSetDescriptors.iterator();
            while (j.hasNext()) {
                ComponentSetDescriptor componentSet = (ComponentSetDescriptor)j.next();
                List componentDescriptors = componentSet.getComponents();
                Iterator k = componentDescriptors.iterator();
                while (k.hasNext()) {
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)k.next();
                    componentDescriptor.setComponentSetDescriptor(componentSet);
                    if (this.getComponentDescriptor(componentDescriptor.getComponentKey()) != null) continue;
                    this.addComponentDescriptor(componentDescriptor);
                    discoveredComponentDescriptors.add(componentDescriptor);
                }
            }
        }
        return discoveredComponentDescriptors;
    }

    public void dispose() {
        this.disposeAllComponents();
    }

    protected void disposeAllComponents() {
        Iterator iter = this.componentManagerManager.getComponentManagers().values().iterator();
        while (iter.hasNext()) {
            try {
                ((ComponentManager)iter.next()).dispose();
            }
            catch (Exception e) {
                this.getLogger().error("Error while disposing component manager. Continuing with the rest", e);
            }
        }
        this.componentManagerManager.getComponentManagers().clear();
    }

    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public ComponentDescriptor getComponentDescriptor(String componentKey) {
        ComponentDescriptor result = this.componentRepository.getComponentDescriptor(componentKey);
        if (result == null && this.parentContainer != null) {
            result = this.parentContainer.getComponentDescriptor(componentKey);
        }
        return result;
    }

    public List getComponentDescriptorList(String role) {
        ArrayList<Object> result = null;
        Map componentDescriptorsByHint = this.getComponentDescriptorMap(role);
        result = componentDescriptorsByHint != null ? new ArrayList(componentDescriptorsByHint.values()) : new ArrayList();
        ComponentDescriptor unhintedDescriptor = this.getComponentDescriptor(role);
        if (unhintedDescriptor != null) {
            result.add(unhintedDescriptor);
        }
        return result;
    }

    public Map getComponentDescriptorMap(String role) {
        Map componentDescriptors;
        Map result = null;
        if (this.parentContainer != null) {
            result = this.parentContainer.getComponentDescriptorMap(role);
        }
        if ((componentDescriptors = this.componentRepository.getComponentDescriptorMap(role)) != null) {
            if (result != null) {
                result.putAll(componentDescriptors);
            } else {
                result = componentDescriptors;
            }
        }
        return result;
    }

    public ClassRealm getComponentRealm(String id) {
        ClassRealm classRealm;
        try {
            if (this.realmAliases.get(id) != null) {
                id = (String)this.realmAliases.get(id);
            }
            classRealm = this.classWorld.getRealm(id);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            classRealm = this.plexusRealm;
        }
        return classRealm;
    }

    protected ClassRealm getContainerRealm() {
        return this.plexusRealm;
    }

    public Context getContext() {
        return this.context;
    }

    public ClassRealm getCoreRealm() {
        return this.coreRealm;
    }

    protected Reader getInterpolationConfigurationReader(Reader reader) {
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader(reader, new ContextMapAdapter(this.context));
        return interpolationFilterReader;
    }

    public Logger getLogger() {
        return super.getLogger();
    }

    public String getName() {
        return this.name;
    }

    protected Map getRealmAliases() {
        return this.realmAliases;
    }

    public boolean hasComponent(String componentKey) {
        return this.componentRepository.hasComponent(componentKey);
    }

    public boolean hasComponent(String role, String roleHint) {
        return this.componentRepository.hasComponent(role, roleHint);
    }

    public void initialize() throws Exception {
        this.realmAliases = new HashMap();
        this.initializeClassWorlds();
        this.initializeConfiguration();
        this.initializeResources();
        this.initializeCoreComponents();
        this.initializeLoggerManager();
        this.initializeContext();
        this.initializeSystemProperties();
    }

    private void initializeClassWorlds() throws Exception {
        if (this.classWorld == null) {
            this.classWorld = new ClassWorld();
        }
        this.initializeName();
        if (this.coreRealm == null) {
            try {
                this.coreRealm = this.classWorld.getRealm("plexus.core");
            }
            catch (NoSuchRealmException noSuchRealmException) {
                this.coreRealm = this.classWorld.newRealm("plexus.core", Thread.currentThread().getContextClassLoader());
            }
        }
        if (this.plexusRealm == null) {
            try {
                this.plexusRealm = this.coreRealm.getWorld().getRealm("plexus.core.maven");
            }
            catch (NoSuchRealmException noSuchRealmException) {
                this.plexusRealm = this.coreRealm;
            }
            this.addContextValue("common.classloader", this.plexusRealm.getClassLoader());
            Thread.currentThread().setContextClassLoader(this.plexusRealm.getClassLoader());
        }
    }

    protected void initializeConfiguration() throws Exception {
        InputStream is = this.coreRealm.getResourceAsStream(BOOTSTRAP_CONFIGURATION);
        if (is == null) {
            throw new IllegalStateException("The internal default plexus-bootstrap.xml is missing. This is highly irregular, your plexus JAR is most likely corrupt.");
        }
        PlexusConfiguration systemConfiguration = PlexusTools.buildConfiguration(new InputStreamReader(is));
        String PLEXUS_XML = "META-INF/plexus/plexus.xml";
        InputStream plexusXml = this.plexusRealm.getResourceAsStream(PLEXUS_XML);
        this.configuration = systemConfiguration;
        if (plexusXml != null) {
            PlexusConfiguration plexusConfiguration = PlexusTools.buildConfiguration(this.getInterpolationConfigurationReader(new InputStreamReader(plexusXml)));
            this.configuration = PlexusConfigurationMerger.merge(plexusConfiguration, this.configuration);
            this.processConfigurationsDirectory();
        }
        if (this.configurationReader != null) {
            PlexusConfiguration userConfiguration = PlexusTools.buildConfiguration(this.getInterpolationConfigurationReader(this.configurationReader));
            this.configuration = PlexusConfigurationMerger.merge(userConfiguration, this.configuration);
            this.processConfigurationsDirectory();
        }
        ConfigurationProcessor p = new ConfigurationProcessor();
        p.addConfigurationResourceHandler(new FileConfigurationResourceHandler());
        p.addConfigurationResourceHandler(new DirectoryConfigurationResourceHandler());
        this.configuration = p.process(this.configuration, new HashMap());
    }

    private void initializeContext() {
        this.addContextValue("plexus", this);
        this.addContextValue("coreRealm", this.plexusRealm);
    }

    private void initializeCoreComponents() throws Exception {
        BasicComponentConfigurator configurator = new BasicComponentConfigurator();
        PlexusConfiguration c = this.configuration.getChild("component-repository");
        this.processCoreComponentConfiguration("component-repository", configurator, c);
        this.componentRepository.configure(this.configuration);
        this.componentRepository.setClassRealm(this.plexusRealm);
        this.componentRepository.initialize();
        c = this.configuration.getChild("lifecycle-handler-manager");
        this.processCoreComponentConfiguration("lifecycle-handler-manager", configurator, c);
        this.lifecycleHandlerManager.initialize();
        c = this.configuration.getChild("component-manager-manager");
        this.processCoreComponentConfiguration("component-manager-manager", configurator, c);
        this.componentManagerManager.setLifecycleHandlerManager(this.lifecycleHandlerManager);
        c = this.configuration.getChild("component-discoverer-manager");
        this.processCoreComponentConfiguration("component-discoverer-manager", configurator, c);
        this.componentDiscovererManager.initialize();
        c = this.configuration.getChild("component-factory-manager");
        this.processCoreComponentConfiguration("component-factory-manager", configurator, c);
        c = this.configuration.getChild("component-composer-manager");
        this.processCoreComponentConfiguration("component-composer-manager", configurator, c);
    }

    private void initializeLoggerManager() throws Exception {
        this.loggerManager = (LoggerManager)this.lookup(LoggerManager.ROLE);
        this.enableLogging(this.loggerManager.getLoggerForComponent((class$org$codehaus$plexus$PlexusContainer != null ? class$org$codehaus$plexus$PlexusContainer : (class$org$codehaus$plexus$PlexusContainer = DefaultPlexusContainer.class$("org.codehaus.plexus.PlexusContainer"))).getName()));
    }

    protected void initializeName() {
        if (this.name == null) {
            int i = 0;
            try {
                while (true) {
                    this.classWorld.getRealm("plexus.app" + i);
                    ++i;
                }
            }
            catch (NoSuchRealmException noSuchRealmException) {
                this.setName("app" + i);
                return;
            }
        }
    }

    public void initializeResources() throws PlexusConfigurationException {
        PlexusConfiguration[] resourceConfigs = this.configuration.getChild("resources").getChildren();
        int i = 0;
        while (i < resourceConfigs.length) {
            try {
                String name = resourceConfigs[i].getName();
                if (name.equals("jar-repository")) {
                    this.addJarRepository(new File(resourceConfigs[i].getValue()));
                } else if (name.equals("directory")) {
                    File directory = new File(resourceConfigs[i].getValue());
                    if (directory.exists() && directory.isDirectory()) {
                        this.plexusRealm.addConstituent(directory.toURL());
                    }
                } else {
                    this.getLogger().warn("Unknown resource type: " + name);
                }
            }
            catch (Exception e) {
                this.getLogger().error("Error configuring resource: " + resourceConfigs[i].getName() + "=" + resourceConfigs[i].getValue(), e);
            }
            ++i;
        }
    }

    private void initializeSystemProperties() throws PlexusConfigurationException {
        PlexusConfiguration[] systemProperties = this.configuration.getChild("system-properties").getChildren("property");
        int i = 0;
        while (i < systemProperties.length) {
            String name = systemProperties[i].getAttribute("name");
            String value = systemProperties[i].getAttribute("value");
            if (name == null) {
                throw new PlexusConfigurationException("Missing 'name' attribute in 'property' tag. ");
            }
            if (value == null) {
                throw new PlexusConfigurationException("Missing 'value' attribute in 'property' tag. ");
            }
            System.getProperties().setProperty(name, value);
            this.getLogger().info("Setting system property: [ " + name + ", " + value + " ]");
            ++i;
        }
    }

    protected void loadComponentsOnStart() throws PlexusConfigurationException, ComponentLookupException {
        PlexusConfiguration[] loadOnStartComponents = this.configuration.getChild("load-on-start").getChildren("component");
        this.getLogger().debug("Found " + loadOnStartComponents.length + " components to load on start");
        int i = 0;
        while (i < loadOnStartComponents.length) {
            String role = loadOnStartComponents[i].getChild("role").getValue(null);
            String roleHint = loadOnStartComponents[i].getChild("role-hint").getValue();
            if (role == null) {
                throw new PlexusConfigurationException("Missing 'role' element from load-on-start.");
            }
            if (roleHint == null) {
                this.getLogger().info("Loading on start [role]: [" + role + "]");
                this.lookup(role);
            } else if (roleHint.equals("*")) {
                this.getLogger().info("Loading on start all components with [role]: [" + role + "]");
                this.lookupList(role);
            } else {
                this.getLogger().info("Loading on start [role,roleHint]: [" + role + "," + roleHint + "]");
                this.lookup(role, roleHint);
            }
            ++i;
        }
    }

    public Object lookup(String componentKey) throws ComponentLookupException {
        Object component = null;
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentKey(componentKey);
        if (componentManager == null) {
            ComponentDescriptor descriptor = this.componentRepository.getComponentDescriptor(componentKey);
            if (descriptor == null) {
                if (this.parentContainer != null) {
                    return this.parentContainer.lookup(componentKey);
                }
                this.getLogger().error("Nonexistent component: " + componentKey);
                String message = "Component descriptor cannot be found in the component repository: " + componentKey + ".";
                throw new ComponentLookupException(message);
            }
            componentManager = this.createComponentManager(descriptor);
        }
        try {
            component = componentManager.getComponent();
            this.componentManagerManager.associateComponentWithComponentManager(component, componentManager);
        }
        catch (Exception e) {
            String message = "Cannot create component for " + componentKey + ".";
            this.getLogger().error(message, e);
            throw new ComponentLookupException(message, e);
        }
        return component;
    }

    public Object lookup(String role, String roleHint) throws ComponentLookupException {
        return this.lookup(String.valueOf(role) + roleHint);
    }

    public List lookupList(String role) throws ComponentLookupException {
        ArrayList<Object> components = new ArrayList<Object>();
        List componentDescriptors = this.getComponentDescriptorList(role);
        if (componentDescriptors != null) {
            Iterator i = componentDescriptors.iterator();
            while (i.hasNext()) {
                ComponentDescriptor descriptor = (ComponentDescriptor)i.next();
                String roleHint = descriptor.getRoleHint();
                Object component = roleHint != null ? this.lookup(role, roleHint) : this.lookup(role);
                components.add(component);
            }
        }
        return components;
    }

    public Map lookupMap(String role) throws ComponentLookupException {
        HashMap<String, Object> components = new HashMap<String, Object>();
        Map componentDescriptors = this.getComponentDescriptorMap(role);
        if (componentDescriptors != null) {
            Iterator i = componentDescriptors.keySet().iterator();
            while (i.hasNext()) {
                String roleHint = (String)i.next();
                Object component = this.lookup(role, roleHint);
                components.put(roleHint, component);
            }
        }
        return components;
    }

    private void processConfigurationsDirectory() throws Exception {
        String s = this.configuration.getChild("configurations-directory").getValue(null);
        if (s != null) {
            PlexusConfiguration componentsConfiguration = this.configuration.getChild("components");
            File configurationsDirectory = new File(s);
            if (configurationsDirectory.exists() && configurationsDirectory.isDirectory()) {
                List componentConfigurationFiles = FileUtils.getFiles(configurationsDirectory, "**/*.conf", "**/*.xml");
                Iterator i = componentConfigurationFiles.iterator();
                while (i.hasNext()) {
                    File componentConfigurationFile = (File)i.next();
                    PlexusConfiguration componentConfiguration = PlexusTools.buildConfiguration(this.getInterpolationConfigurationReader(new FileReader(componentConfigurationFile)));
                    componentsConfiguration.addChild(componentConfiguration.getChild("components"));
                }
            }
        }
    }

    private void processCoreComponentConfiguration(String role, BasicComponentConfigurator configurator, PlexusConfiguration c) throws ComponentConfigurationException {
        String implementation = c.getAttribute("implementation", null);
        if (implementation == null) {
            String msg = "Core component: '" + role + "' + which is needed by plexus to function properly cannot " + "be instantiated. Implementation attribute was not specified in plexus.conf." + "This is highly irregular, your plexus JAR is most likely corrupt.";
            throw new ComponentConfigurationException(msg);
        }
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.setRole(role);
        componentDescriptor.setImplementation(implementation);
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration("configuration");
        configuration.addChild(c);
        try {
            configurator.configureComponent(this, configuration);
        }
        catch (ComponentConfigurationException e) {
            String message = "Error configuring component: " + componentDescriptor.getHumanReadableKey();
            throw new ComponentConfigurationException(message, e);
        }
    }

    public void registerComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.registerComponentDiscoveryListener(listener);
    }

    public void registerComponentDiscoverytListeners() throws Exception {
        List listeners = this.componentDiscovererManager.getListenerDescriptors();
        if (listeners != null) {
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                DiscoveryListenerDescriptor listenerDescriptor = (DiscoveryListenerDescriptor)i.next();
                String role = listenerDescriptor.getRole();
                ComponentDiscoveryListener l = (ComponentDiscoveryListener)this.lookup(role);
                this.componentDiscovererManager.registerComponentDiscoveryListener(l);
            }
        }
    }

    public void release(Object component) throws Exception {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        if (componentManager == null) {
            if (this.parentContainer != null) {
                this.parentContainer.release(component);
            } else {
                this.getLogger().warn("Component manager not found for returned component. Ignored. component=" + component);
            }
        } else {
            componentManager.release(component);
        }
    }

    public void releaseAll(List components) throws Exception {
        Iterator i = components.iterator();
        while (i.hasNext()) {
            Object component = i.next();
            this.release(component);
        }
    }

    public void releaseAll(Map components) throws Exception {
        Iterator i = components.values().iterator();
        while (i.hasNext()) {
            Object component = i.next();
            this.release(component);
        }
    }

    public void removeComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.removeComponentDiscoveryListener(listener);
    }

    public void resume(Object component) throws Exception {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        componentManager.resume(component);
    }

    public void setClassWorld(ClassWorld classWorld) {
        this.classWorld = classWorld;
    }

    public void setConfigurationResource(Reader configuration) throws PlexusConfigurationResourceException {
        this.configurationReader = configuration;
    }

    public void setCoreRealm(ClassRealm coreRealm) {
        this.coreRealm = coreRealm;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentPlexusContainer(PlexusContainer parentContainer) {
        this.parentContainer = parentContainer;
    }

    public void start() throws Exception {
        this.registerComponentDiscoverytListeners();
        this.discoverComponents(this.plexusRealm);
        this.loadComponentsOnStart();
        this.configuration = null;
    }

    public void suspend(Object component) throws Exception {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        componentManager.suspend(component);
    }
}

