/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class FileUtils {
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    public static final int ONE_GB = 0x40000000;
    public static String FS = System.getProperty("file.separator");

    public static String basename(String string) {
        return FileUtils.basename(string, FileUtils.extension(string));
    }

    public static String basename(String string, String string2) {
        int n;
        int n2 = string.lastIndexOf(File.separator) + 1;
        int n3 = n = string2 != null && string2.length() > 0 ? string.lastIndexOf(string2) : -1;
        if (n >= 0) {
            return string.substring(n2, n);
        }
        if (n2 > 0) {
            return string.substring(n2);
        }
        return string;
    }

    private static Vector blendFilesToVector(Vector vector, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        return vector;
    }

    public static String byteCountToDisplaySize(int n) {
        String string = n / 0x40000000 > 0 ? String.valueOf(String.valueOf(n / 0x40000000)) + " GB" : (n / 0x100000 > 0 ? String.valueOf(String.valueOf(n / 0x100000)) + " MB" : (n / 1024 > 0 ? String.valueOf(String.valueOf(n / 1024)) + " KB" : String.valueOf(String.valueOf(n)) + " bytes"));
        return string;
    }

    public static String catPath(String string, String string2) {
        int n = string.lastIndexOf("/");
        String string3 = string.substring(0, n);
        String string4 = string2;
        while (string4.startsWith("../")) {
            if (string3.length() <= 0) {
                return null;
            }
            n = string3.lastIndexOf("/");
            string3 = string3.substring(0, n);
            n = string4.indexOf("../") + 3;
            string4 = string4.substring(n);
        }
        return string3 + "/" + string4;
    }

    public static void cleanDirectory(File file) throws IOException {
        if (!file.exists()) {
            String string = String.valueOf(String.valueOf(file)) + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = String.valueOf(String.valueOf(file)) + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        IOException iOException = null;
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            try {
                FileUtils.forceDelete(file2);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            ++n;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public static void cleanDirectory(String string) throws IOException {
        FileUtils.cleanDirectory(new File(string));
    }

    private static void cleanDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            String string = String.valueOf(String.valueOf(file)) + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = String.valueOf(String.valueOf(file)) + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        IOException iOException = null;
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            try {
                FileUtils.forceDeleteOnExit(file2);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            ++n;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public static boolean contentEquals(File file, File file2) throws IOException {
        boolean bl;
        boolean bl2 = file.exists();
        if (bl2 != file2.exists()) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        if (file.isDirectory() || file2.isDirectory()) {
            return false;
        }
        FileInputStream fileInputStream = null;
        InputStream inputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStream = new FileInputStream(file2);
            bl = IOUtil.contentEquals(fileInputStream, inputStream);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ((InputStream)fileInputStream).close();
            inputStream.close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        inputStream.close();
        return bl;
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileUtils.copyDirectory(file, file2, "**", null);
    }

    public static void copyDirectory(File file, File file2, String string, String string2) throws IOException {
        if (!file.exists()) {
            return;
        }
        List list = FileUtils.getFiles(file, string, string2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file3 = (File)iterator.next();
            FileUtils.copyFileToDirectory(file3, file2);
        }
    }

    public static void copyDirectoryStructure(File file, File file2) throws IOException {
        if (!file.exists()) {
            throw new IOException("Source directory doesn't exists (" + file.getAbsolutePath() + ").");
        }
        File[] fileArray = file.listFiles();
        String string = file.getAbsolutePath();
        int n = 0;
        while (n < fileArray.length) {
            File file3 = fileArray[n];
            String string2 = file3.getAbsolutePath();
            string2 = string2.substring(string.length() + 1);
            File file4 = new File(file2, string2);
            if (file3.isFile()) {
                file4 = file4.getParentFile();
                FileUtils.copyFileToDirectory(file3, file4);
            } else if (file3.isDirectory()) {
                if (!file4.exists() && !file4.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + file4.getAbsolutePath() + "'.");
                }
                FileUtils.copyDirectoryStructure(file3, file4);
            } else {
                throw new IOException("Unknown file type: " + file3.getAbsolutePath());
            }
            ++n;
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        if (!file.exists()) {
            String string = "File " + file + " does not exist";
            throw new IOException(string);
        }
        if (file2.getParentFile() != null && !file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        if (file2.exists() && !file2.canWrite()) {
            String string = "Unable to open file " + file2 + " for writing.";
            throw new IOException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        IOUtil.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
        fileInputStream.close();
        fileOutputStream.close();
        if (file.length() != file2.length()) {
            String string = "Failed to copy full contents from " + file + " to " + file2;
            throw new IOException(string);
        }
    }

    public static void copyFileToDirectory(File file, File file2) throws IOException {
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtils.copyFile(file, new File(file2, file.getName()));
    }

    public static void copyFileToDirectory(String string, String string2) throws IOException {
        FileUtils.copyFileToDirectory(new File(string), new File(string2));
    }

    public static void copyURLToFile(URL uRL, File file) throws IOException {
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists() && !file.canWrite()) {
            String string = "Unable to open file " + file + " for writing.";
            throw new IOException(string);
        }
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOUtil.copy(inputStream, (OutputStream)fileOutputStream);
        inputStream.close();
        fileOutputStream.close();
    }

    public static File createTempFile(String string, String string2, File file) {
        Random random;
        File file2 = null;
        String string3 = System.getProperty("java.io.tmpdir");
        if (file != null) {
            string3 = file.getPath();
        }
        DecimalFormat decimalFormat = new DecimalFormat("#####");
        Random random2 = random = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
        synchronized (random2) {
            while ((file2 = new File(string3, String.valueOf(string) + decimalFormat.format(Math.abs(random.nextInt())) + string2)).exists()) {
            }
        }
        return file2;
    }

    public static void deleteDirectory(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        FileUtils.cleanDirectory(file);
        if (!file.delete()) {
            String string = "Directory " + file + " unable to be deleted.";
            throw new IOException(string);
        }
    }

    public static void deleteDirectory(String string) throws IOException {
        FileUtils.deleteDirectory(new File(string));
    }

    private static void deleteDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        FileUtils.cleanDirectoryOnExit(file);
        file.deleteOnExit();
    }

    public static String dirname(String string) {
        int n = string.lastIndexOf(File.separator);
        return n >= 0 ? string.substring(0, n) : "";
    }

    public static String extension(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static void fileDelete(String string) {
        File file = new File(string);
        file.delete();
    }

    public static boolean fileExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static String fileRead(File file) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[512];
        while ((n = fileInputStream.read(byArray)) > 0) {
            stringBuffer.append(new String(byArray, 0, n));
        }
        fileInputStream.close();
        return stringBuffer.toString();
    }

    public static String fileRead(String string) throws IOException {
        return FileUtils.fileRead(new File(string));
    }

    public static void fileWrite(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(string2.getBytes());
        fileOutputStream.close();
    }

    public static String filename(String string) {
        int n = string.lastIndexOf(File.separator);
        return n >= 0 ? string.substring(n + 1) : string;
    }

    public static void forceDelete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else if (!file.delete()) {
            String string = "File " + file + " unable to be deleted.";
            throw new IOException(string);
        }
    }

    public static void forceDelete(String string) throws IOException {
        FileUtils.forceDelete(new File(string));
    }

    public static void forceDeleteOnExit(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    public static void forceMkdir(File file) throws IOException {
        if (file.exists()) {
            if (file.isFile()) {
                String string = "File " + file + " exists and is " + "not a directory. Unable to create directory.";
                throw new IOException(string);
            }
        } else if (!file.mkdirs()) {
            String string = "Unable to create directory " + file;
            throw new IOException(string);
        }
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static File getFile(String string) {
        return new File(string);
    }

    public static List getFileNames(File file, String string, String string2, boolean bl) throws IOException {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(file);
        if (string != null) {
            directoryScanner.setIncludes(StringUtils.split(string, ","));
        }
        if (string2 != null) {
            directoryScanner.setExcludes(StringUtils.split(string2, ","));
        }
        directoryScanner.scan();
        String[] stringArray = directoryScanner.getIncludedFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (bl) {
                arrayList.add(String.valueOf(String.valueOf(file)) + FS + stringArray[n]);
            } else {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    public static List getFiles(File file, String string, String string2) throws IOException {
        return FileUtils.getFiles(file, string, string2, true);
    }

    public static List getFiles(File file, String string, String string2, boolean bl) throws IOException {
        List list = FileUtils.getFileNames(file, string, string2, bl);
        ArrayList<File> arrayList = new ArrayList<File>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new File((String)iterator.next()));
        }
        return arrayList;
    }

    public static String[] getFilesFromExtension(String string, String[] stringArray) {
        Object object;
        Vector vector = new Vector();
        File file = new File(string);
        String[] stringArray2 = file.list();
        if (stringArray2 == null) {
            return new String[0];
        }
        int n = 0;
        while (n < stringArray2.length) {
            String[] stringArray3;
            object = String.valueOf(string) + System.getProperty("file.separator") + stringArray2[n];
            File file2 = new File((String)object);
            if (file2.isDirectory()) {
                if (!file2.getName().equals("CVS")) {
                    stringArray3 = FileUtils.getFilesFromExtension((String)object, stringArray);
                    vector = FileUtils.blendFilesToVector(vector, stringArray3);
                }
            } else {
                stringArray3 = file2.getAbsolutePath();
                if (FileUtils.isValidFile((String)stringArray3, stringArray)) {
                    vector.addElement(stringArray3);
                }
            }
            ++n;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public static String getPath(String string) {
        return FileUtils.getPath(string, File.separatorChar);
    }

    public static String getPath(String string, char c) {
        int n = string.lastIndexOf(c);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    private static boolean isValidFile(String string, String[] stringArray) {
        String string2 = FileUtils.extension(string);
        if (string2 == null) {
            string2 = "";
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void mkdir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static String normalize(String string) {
        int n;
        String string2 = string;
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = String.valueOf(string2.substring(0, n)) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = String.valueOf(string2.substring(0, n)) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = String.valueOf(string2.substring(0, n2)) + string2.substring(n + 3);
        }
        return string2;
    }

    public static String removeExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String removePath(String string) {
        return FileUtils.removePath(string, File.separatorChar);
    }

    public static String removePath(String string, char c) {
        int n = string.lastIndexOf(c);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static void rename(File file, File file2) throws IOException {
        if (file2.exists() && !file2.delete()) {
            throw new IOException("Failed to delete " + file2 + " while trying to rename " + file);
        }
        File file3 = file2.getParentFile();
        if (file3 != null && !file3.exists() && !file3.mkdirs()) {
            throw new IOException("Failed to create directory " + file3 + " while trying to rename " + file);
        }
        if (!file.renameTo(file2)) {
            FileUtils.copyFile(file, file2);
            if (!file.delete()) {
                throw new IOException("Failed to delete " + file + " while trying to rename it.");
            }
        }
    }

    public static File resolveFile(File file, String string) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string.replace('/', File.separatorChar);
        }
        if (File.separatorChar != '\\') {
            string2 = string.replace('\\', File.separatorChar);
        }
        if (string2.startsWith(File.separator)) {
            File file2 = new File(string2);
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (IOException iOException) {}
            return file2;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (File.separatorChar == '\\') {
            stringBuffer.append(string2.charAt(0));
            ++n;
        }
        int n2 = n;
        while (n2 < cArray.length) {
            boolean bl;
            boolean bl2 = bl = File.separatorChar == cArray[n2] && File.separatorChar == cArray[n2 - 1];
            if (!bl) {
                stringBuffer.append(cArray[n2]);
            }
            ++n2;
        }
        string2 = stringBuffer.toString();
        File file3 = new File(file, string2).getAbsoluteFile();
        try {
            file3 = file3.getCanonicalFile();
        }
        catch (IOException iOException) {}
        return file3;
    }

    public static long sizeOfDirectory(File file) {
        if (!file.exists()) {
            String string = String.valueOf(String.valueOf(file)) + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = String.valueOf(String.valueOf(file)) + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            l = file2.isDirectory() ? (l += FileUtils.sizeOfDirectory(file2)) : (l += file2.length());
            ++n;
        }
        return l;
    }

    public static long sizeOfDirectory(String string) {
        return FileUtils.sizeOfDirectory(new File(string));
    }

    public static File toFile(URL uRL) {
        if (!uRL.getProtocol().equals("file")) {
            return null;
        }
        String string = uRL.getFile().replace('/', File.separatorChar);
        return new File(string);
    }

    public static URL[] toURLs(File[] fileArray) throws IOException {
        URL[] uRLArray = new URL[fileArray.length];
        int n = 0;
        while (n < uRLArray.length) {
            uRLArray[n] = fileArray[n].toURL();
            ++n;
        }
        return uRLArray;
    }

    public static boolean waitFor(File file, int n) {
        int n2 = 0;
        int n3 = 0;
        while (!file.exists()) {
            if (n3++ >= 10) {
                n3 = 0;
                if (n2++ > n) {
                    return false;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    public static boolean waitFor(String string, int n) {
        return FileUtils.waitFor(new File(string), n);
    }
}

