/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.logging.console;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.logging.AbstractLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

public class ConsoleLoggerManager
extends AbstractLoggerManager
implements LoggerManager,
Initializable {
    private String threshold = "info";
    private int currentThreshold;
    private Map loggers;
    private int loggerCount;
    private boolean bootTimeLogger = false;

    public ConsoleLoggerManager() {
    }

    public ConsoleLoggerManager(String string) {
        this.threshold = string;
        this.bootTimeLogger = true;
        this.initialize();
    }

    private void debug(String string) {
    }

    private String decodeLogLevel(int n) {
        switch (n) {
            case 0: {
                return "debug";
            }
            case 1: {
                return "info";
            }
            case 2: {
                return "warn";
            }
            case 3: {
                return "error";
            }
            case 4: {
                return "fatal";
            }
            case 5: {
                return "disabled";
            }
        }
        return "unknown";
    }

    public int getActiveLoggerCount() {
        return this.loggers.size();
    }

    public Logger getLoggerForComponent(String string, String string2) {
        String string3 = this.toMapKey(string, string2);
        Logger logger = (Logger)this.loggers.get(string3);
        if (logger != null) {
            return logger;
        }
        this.debug("Creating logger '" + string3 + "' " + this.hashCode() + ".");
        logger = new ConsoleLogger(this.getThreshold(), string3);
        this.loggers.put(string3, logger);
        return logger;
    }

    public int getThreshold() {
        return this.currentThreshold;
    }

    public int getThreshold(String string, String string2) {
        String string3 = this.toMapKey(string, string2);
        ConsoleLogger consoleLogger = (ConsoleLogger)this.loggers.get(string3);
        if (consoleLogger == null) {
            this.debug("Trying to get the threshold of a unknown logger '" + string3 + "'.");
            return 0;
        }
        return consoleLogger.getThreshold();
    }

    public void initialize() {
        this.debug("Initializing ConsoleLoggerManager: " + this.hashCode() + ".");
        this.currentThreshold = this.parseThreshold(this.threshold);
        if (this.currentThreshold == -1) {
            this.debug("Could not parse the threshold level: '" + this.threshold + "', setting to debug.");
            this.currentThreshold = 0;
        }
        this.loggers = new HashMap();
    }

    private int parseThreshold(String string) {
        if ((string = string.trim().toLowerCase()).equals("debug")) {
            return 0;
        }
        if (string.equals("info")) {
            return 1;
        }
        if (string.equals("warn")) {
            return 2;
        }
        if (string.equals("error")) {
            return 3;
        }
        if (string.equals("fatal")) {
            return 4;
        }
        return -1;
    }

    public void returnComponentLogger(String string, String string2) {
        String string3 = this.toMapKey(string, string2);
        Object v = this.loggers.remove(string3);
        if (v == null) {
            this.debug("There was no such logger '" + string3 + "' " + this.hashCode() + ".");
        } else {
            this.debug("Removed logger '" + string3 + "' " + this.hashCode() + ".");
        }
    }

    public void setThreshold(int n) {
        this.currentThreshold = n;
    }

    public void setThreshold(String string, String string2, int n) {
        String string3 = this.toMapKey(string, string2);
        ConsoleLogger consoleLogger = (ConsoleLogger)this.loggers.get(string3);
        if (consoleLogger == null) {
            this.debug("Trying to set the threshold of a unknown logger '" + string3 + "'.");
            return;
        }
        consoleLogger.setThreshold(n);
    }
}

