/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.embed;

import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.PlexusEmbedder;
import org.codehaus.plexus.util.PropertyUtils;

public class Embedder
implements PlexusEmbedder {
    private URL configurationURL;
    private Properties properties;
    private final DefaultPlexusContainer container = new DefaultPlexusContainer();
    private boolean embedderStarted = false;
    private boolean embedderStopped = false;

    public synchronized void addContextValue(Object object, Object object2) {
        if (this.embedderStarted || this.embedderStopped) {
            throw new IllegalStateException("Embedder has already been started");
        }
        this.container.addContextValue(object, object2);
    }

    public synchronized PlexusContainer getContainer() {
        if (!this.embedderStarted) {
            throw new IllegalStateException("Embedder must be started");
        }
        return this.container;
    }

    public boolean hasComponent(String string) {
        return this.getContainer().hasComponent(string);
    }

    public boolean hasComponent(String string, String string2) {
        return this.getContainer().hasComponent(string, string2);
    }

    protected synchronized void initializeContext() {
        Set set = ((Hashtable)this.properties).keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.properties.getProperty(string);
            this.container.addContextValue(string, string2);
        }
    }

    public Object lookup(String string) throws ComponentLookupException {
        return this.getContainer().lookup(string);
    }

    public Object lookup(String string, String string2) throws ComponentLookupException {
        return this.getContainer().lookup(string, string2);
    }

    public void release(Object object) throws Exception {
        this.getContainer().release(object);
    }

    public synchronized void setClassWorld(ClassWorld classWorld) {
        this.container.setClassWorld(classWorld);
    }

    public synchronized void setConfiguration(URL uRL) {
        if (this.embedderStarted || this.embedderStopped) {
            throw new IllegalStateException("Embedder has already been started");
        }
        this.configurationURL = uRL;
    }

    public synchronized void setProperties(File file) {
        this.properties = PropertyUtils.loadProperties(file);
    }

    public synchronized void setProperties(Properties properties) {
        this.properties = properties;
    }

    public synchronized void start() throws Exception {
        if (this.embedderStarted) {
            throw new IllegalStateException("Embedder already started");
        }
        if (this.embedderStopped) {
            throw new IllegalStateException("Embedder cannot be restarted");
        }
        if (this.configurationURL != null) {
            this.container.setConfigurationResource(new InputStreamReader(this.configurationURL.openStream()));
        }
        if (this.properties != null) {
            this.initializeContext();
        }
        this.container.initialize();
        this.embedderStarted = true;
        this.container.start();
    }

    public synchronized void start(ClassWorld classWorld) throws Exception {
        this.container.setClassWorld(classWorld);
        this.start();
    }

    public synchronized void stop() throws Exception {
        if (this.embedderStopped) {
            throw new IllegalStateException("Embedder already stopped");
        }
        if (!this.embedderStarted) {
            throw new IllegalStateException("Embedder not started");
        }
        this.container.dispose();
        this.embedderStarted = false;
        this.embedderStopped = true;
    }
}

