/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.context;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;

public class DefaultContext
implements Context {
    private static Hidden HIDDEN_MAKER = new Hidden();
    private Map contextData;
    private Context parent;
    private boolean readOnly;

    public DefaultContext() {
        this((Context)null);
    }

    public DefaultContext(Map map) {
        this(map, null);
    }

    public DefaultContext(Map map, Context context) {
        this.parent = context;
        this.contextData = map;
    }

    public DefaultContext(Context context) {
        this(new Hashtable(), context);
    }

    protected void checkWriteable() throws IllegalStateException {
        if (this.readOnly) {
            throw new IllegalStateException("Context is read only and can not be modified");
        }
    }

    public boolean contains(Object object) {
        Object v = this.contextData.get(object);
        if (v != null) {
            return !(v instanceof Hidden);
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.contains(object);
    }

    public Object get(Object object) throws ContextException {
        Object v = this.contextData.get(object);
        if (v != null) {
            if (v instanceof Hidden) {
                throw new ContextException("Unable to locate " + object);
            }
            return v;
        }
        if (this.parent == null) {
            throw new ContextException("Unable to resolve context key: " + object);
        }
        return this.parent.get(object);
    }

    protected Map getContextData() {
        return this.contextData;
    }

    protected Context getParent() {
        return this.parent;
    }

    public void hide(Object object) throws IllegalStateException {
        this.checkWriteable();
        this.contextData.put(object, HIDDEN_MAKER);
    }

    public void makeReadOnly() {
        this.readOnly = true;
    }

    public void put(Object object, Object object2) throws IllegalStateException {
        this.checkWriteable();
        if (object2 == null) {
            this.contextData.remove(object);
        } else {
            this.contextData.put(object, object2);
        }
    }

    private static class Hidden
    implements Serializable {
        Hidden() {
        }
    }
}

