/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration.processor;

import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.processor.AbstractConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessingException;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;

public class DirectoryConfigurationResourceHandler
extends AbstractConfigurationResourceHandler {
    public String getId() {
        return "directory-configuration-resource";
    }

    public PlexusConfiguration[] handleRequest(Map map) throws ConfigurationResourceNotFoundException, ConfigurationProcessingException {
        File file = new File(this.getSource(map));
        if (!file.exists()) {
            throw new ConfigurationResourceNotFoundException("The specified resource " + file + " cannot be found.");
        }
        if (!file.isDirectory()) {
            throw new ConfigurationResourceNotFoundException("The specified resource " + file + " is not a directory.");
        }
        String string = (String)map.get("includes");
        if (string == null) {
            string = "**/*.xml";
        }
        String string2 = (String)map.get("excludes");
        try {
            List list = FileUtils.getFiles(file, string, string2);
            PlexusConfiguration[] plexusConfigurationArray = new PlexusConfiguration[list.size()];
            int n = 0;
            while (n < plexusConfigurationArray.length) {
                PlexusConfiguration plexusConfiguration;
                File file2 = (File)list.get(n);
                plexusConfigurationArray[n] = plexusConfiguration = PlexusTools.buildConfiguration(new FileReader(file2));
                ++n;
            }
            return plexusConfigurationArray;
        }
        catch (Exception exception) {
            throw new ConfigurationProcessingException(exception);
        }
    }
}

