/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository.io;

import java.io.Reader;
import java.io.StringReader;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public class PlexusTools {
    public static ComponentDescriptor buildComponentDescriptor(String string) throws Exception {
        return PlexusTools.buildComponentDescriptor(PlexusTools.buildConfiguration(string));
    }

    public static ComponentDescriptor buildComponentDescriptor(PlexusConfiguration plexusConfiguration) throws Exception {
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.setRole(plexusConfiguration.getChild("role").getValue());
        componentDescriptor.setRoleHint(plexusConfiguration.getChild("role-hint").getValue());
        componentDescriptor.setImplementation(plexusConfiguration.getChild("implementation").getValue());
        componentDescriptor.setVersion(plexusConfiguration.getChild("version").getValue());
        componentDescriptor.setComponentType(plexusConfiguration.getChild("component-type").getValue());
        componentDescriptor.setInstantiationStrategy(plexusConfiguration.getChild("instantiation-strategy").getValue());
        componentDescriptor.setLifecycleHandler(plexusConfiguration.getChild("lifecycle-handler").getValue());
        componentDescriptor.setComponentProfile(plexusConfiguration.getChild("component-profile").getValue());
        componentDescriptor.setComponentComposer(plexusConfiguration.getChild("component-composer").getValue());
        componentDescriptor.setComponentFactory(plexusConfiguration.getChild("component-factory").getValue());
        componentDescriptor.setDescription(plexusConfiguration.getChild("description").getValue());
        componentDescriptor.setAlias(plexusConfiguration.getChild("alias").getValue());
        String string = plexusConfiguration.getChild("isolated-realm").getValue();
        if (string != null) {
            componentDescriptor.setIsolatedRealm(string.equals("true"));
        }
        componentDescriptor.setConfiguration(plexusConfiguration.getChild("configuration"));
        PlexusConfiguration[] plexusConfigurationArray = plexusConfiguration.getChild("requirements").getChildren("requirement");
        int n = 0;
        while (n < plexusConfigurationArray.length) {
            PlexusConfiguration plexusConfiguration2 = plexusConfigurationArray[n];
            ComponentRequirement componentRequirement = new ComponentRequirement();
            componentRequirement.setRole(plexusConfiguration2.getChild("role").getValue());
            componentRequirement.setRoleHint(plexusConfiguration2.getChild("role-hint").getValue());
            componentRequirement.setFieldName(plexusConfiguration2.getChild("field-name").getValue());
            componentDescriptor.addRequirement(componentRequirement);
            ++n;
        }
        return componentDescriptor;
    }

    public static ComponentSetDescriptor buildComponentSet(PlexusConfiguration plexusConfiguration) throws Exception {
        PlexusConfiguration[] plexusConfigurationArray;
        ComponentSetDescriptor componentSetDescriptor = new ComponentSetDescriptor();
        PlexusConfiguration[] plexusConfigurationArray2 = plexusConfiguration.getChild("components").getChildren("component");
        int n = 0;
        while (n < plexusConfigurationArray2.length) {
            plexusConfigurationArray = plexusConfigurationArray2[n];
            componentSetDescriptor.addComponentDescriptor(PlexusTools.buildComponentDescriptor((PlexusConfiguration)plexusConfigurationArray));
            ++n;
        }
        plexusConfigurationArray = plexusConfiguration.getChild("dependencies").getChildren("dependency");
        int n2 = 0;
        while (n2 < plexusConfigurationArray.length) {
            PlexusConfiguration plexusConfiguration2 = plexusConfigurationArray[n2];
            ComponentDependency componentDependency = new ComponentDependency();
            componentDependency.setArtifactId(plexusConfiguration2.getChild("artifact-id").getValue());
            componentDependency.setGroupId(plexusConfiguration2.getChild("group-id").getValue());
            componentDependency.setType(plexusConfiguration2.getChild("type").getValue());
            componentDependency.setVersion(plexusConfiguration2.getChild("version").getValue());
            componentSetDescriptor.addDependency(componentDependency);
            ++n2;
        }
        return componentSetDescriptor;
    }

    public static PlexusConfiguration buildConfiguration(Reader reader) throws Exception {
        return new XmlPlexusConfiguration(Xpp3DomBuilder.build(reader));
    }

    public static PlexusConfiguration buildConfiguration(String string) throws Exception {
        return PlexusTools.buildConfiguration(new StringReader(string));
    }
}

