/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.CompositionResolver;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.component.repository.exception.ComponentImplementationNotFoundException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultComponentRepository
extends AbstractLogEnabled
implements ComponentRepository {
    private static String COMPONENTS = "components";
    private static String COMPONENT = "component";
    private PlexusConfiguration configuration;
    private Map componentDescriptorMaps;
    private Map componentDescriptors = new HashMap();
    private CompositionResolver compositionResolver;
    private ClassRealm classRealm;

    public DefaultComponentRepository() {
        this.componentDescriptorMaps = new HashMap();
    }

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentRepositoryException {
        try {
            this.validateComponentDescriptor(componentDescriptor);
        }
        catch (ComponentImplementationNotFoundException componentImplementationNotFoundException) {
            throw new ComponentRepositoryException("Component descriptor validation failed: ", componentImplementationNotFoundException);
        }
        String string = componentDescriptor.getRoleHint();
        if (string != null) {
            String string2 = componentDescriptor.getRole();
            HashMap<String, ComponentDescriptor> hashMap = (HashMap<String, ComponentDescriptor>)this.componentDescriptorMaps.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap<String, ComponentDescriptor>();
                this.componentDescriptorMaps.put(string2, hashMap);
            }
            hashMap.put(string, componentDescriptor);
        }
        try {
            this.compositionResolver.addComponentDescriptor(componentDescriptor);
        }
        catch (CompositionException compositionException) {
            throw new ComponentRepositoryException(compositionException.getMessage(), compositionException);
        }
        this.componentDescriptors.put(componentDescriptor.getComponentKey(), componentDescriptor);
    }

    public void addComponentDescriptor(PlexusConfiguration plexusConfiguration) throws ComponentRepositoryException {
        ComponentDescriptor componentDescriptor = null;
        try {
            componentDescriptor = PlexusTools.buildComponentDescriptor(plexusConfiguration);
        }
        catch (Exception exception) {
            throw new ComponentRepositoryException("Cannot unmarshall component descriptor:", exception);
        }
        this.addComponentDescriptor(componentDescriptor);
    }

    public void configure(PlexusConfiguration plexusConfiguration) {
        this.configuration = plexusConfiguration;
    }

    public List getComponentDependencies(ComponentDescriptor componentDescriptor) {
        return this.compositionResolver.getRequirements(componentDescriptor.getComponentKey());
    }

    public ComponentDescriptor getComponentDescriptor(String string) {
        return (ComponentDescriptor)this.componentDescriptors.get(string);
    }

    public Map getComponentDescriptorMap(String string) {
        return (Map)this.componentDescriptorMaps.get(string);
    }

    protected PlexusConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean hasComponent(String string) {
        return this.componentDescriptors.containsKey(string);
    }

    public boolean hasComponent(String string, String string2) {
        return this.componentDescriptors.containsKey(String.valueOf(string) + string2);
    }

    public void initialize() throws Exception {
        this.initializeComponentDescriptors();
    }

    public void initializeComponentDescriptors() throws Exception {
        this.initializeComponentDescriptorsFromUserConfiguration();
    }

    private void initializeComponentDescriptorsFromUserConfiguration() throws Exception {
        PlexusConfiguration[] plexusConfigurationArray = this.configuration.getChild(COMPONENTS).getChildren(COMPONENT);
        int n = 0;
        while (n < plexusConfigurationArray.length) {
            this.addComponentDescriptor(plexusConfigurationArray[n]);
            ++n;
        }
    }

    public void setClassRealm(ClassRealm classRealm) {
        this.classRealm = classRealm;
    }

    public void validateComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentImplementationNotFoundException {
    }
}

