/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.manager;

import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.codehaus.plexus.logging.Logger;

public abstract class AbstractComponentManager
implements ComponentManager,
Cloneable {
    private PlexusContainer container;
    private ComponentDescriptor componentDescriptor;
    private LifecycleHandler lifecycleHandler;
    private int connections;
    private String id = null;

    protected boolean connected() {
        return this.connections > 0;
    }

    public ComponentManager copy() {
        try {
            ComponentManager componentManager = (ComponentManager)this.clone();
            return componentManager;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected Object createComponentInstance() throws Exception {
        Object object = this.container.createComponentInstance(this.componentDescriptor);
        this.startComponentLifecycle(object);
        return object;
    }

    protected void decrementConnectionCount() {
        --this.connections;
    }

    public abstract void dispose() throws Exception;

    protected void endComponentLifecycle(Object object) throws Exception {
        this.getLifecycleHandler().end(object, this);
    }

    public abstract Object getComponent() throws Exception;

    public ComponentDescriptor getComponentDescriptor() {
        return this.componentDescriptor;
    }

    public int getConnections() {
        return this.connections;
    }

    public PlexusContainer getContainer() {
        return this.container;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    public Logger getLogger() {
        return this.container.getLogger();
    }

    protected void incrementConnectionCount() {
        ++this.connections;
    }

    public void initialize() throws Exception {
    }

    public abstract void release(Object var1) throws Exception;

    public void resume(Object object) throws Exception {
        this.getLifecycleHandler().resume(object, this);
    }

    public void setup(PlexusContainer plexusContainer, LifecycleHandler lifecycleHandler, ComponentDescriptor componentDescriptor) throws Exception {
        this.container = plexusContainer;
        this.lifecycleHandler = lifecycleHandler;
        this.componentDescriptor = componentDescriptor;
    }

    protected void startComponentLifecycle(Object object) throws Exception {
        this.getLifecycleHandler().start(object, this);
    }

    public void suspend(Object object) throws Exception {
        this.getLifecycleHandler().suspend(object, this);
    }
}

