/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.discovery;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public abstract class AbstractComponentDiscoverer
implements ComponentDiscoverer {
    private ComponentDiscovererManager manager;

    protected abstract ComponentSetDescriptor createComponentDescriptors(Reader var1, String var2) throws Exception;

    public List findComponents(Context context, ClassRealm classRealm) {
        ArrayList<ComponentSetDescriptor> arrayList = new ArrayList<ComponentSetDescriptor>();
        try {
            Enumeration enumeration = classRealm.findResources(this.getComponentDescriptorLocation());
            while (enumeration.hasMoreElements()) {
                URL uRL = (URL)enumeration.nextElement();
                InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader(new InputStreamReader(uRL.openStream()), new ContextMapAdapter(context));
                String string = IOUtil.toString(interpolationFilterReader);
                ComponentSetDescriptor componentSetDescriptor = this.createComponentDescriptors(new StringReader(string), uRL.toString());
                arrayList.add(componentSetDescriptor);
                ComponentDiscoveryEvent componentDiscoveryEvent = new ComponentDiscoveryEvent(componentSetDescriptor);
                this.manager.fireComponentDiscoveryEvent(componentDiscoveryEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    protected abstract String getComponentDescriptorLocation();

    public void setManager(ComponentDiscovererManager componentDiscovererManager) {
        this.manager = componentDiscovererManager;
    }
}

