/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;

public class PlexusTestCase
extends TestCase {
    protected PlexusContainer container;
    protected String basedir;
    private static String basedirPath;

    public PlexusTestCase() {
    }

    public PlexusTestCase(String string) {
        super(string);
    }

    protected PlexusContainer createContainerInstance() {
        return new DefaultPlexusContainer();
    }

    protected void customizeContext() throws Exception {
    }

    protected void customizeContext(Context context) throws Exception {
    }

    public static String getBasedir() {
        if (basedirPath != null) {
            return basedirPath;
        }
        basedirPath = System.getProperty("basedir");
        if (basedirPath == null) {
            basedirPath = new File("").getAbsolutePath();
        }
        return basedirPath;
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected InputStream getConfiguration() throws Exception {
        return this.getConfiguration(null);
    }

    protected InputStream getConfiguration(String string) throws Exception {
        String string2 = ((Object)((Object)this)).getClass().getName();
        String string3 = string2.substring(string2.lastIndexOf(".") + 1);
        String string4 = null;
        string4 = string == null || string.equals("") ? String.valueOf(string3) + ".xml" : String.valueOf(string3) + "-" + string + ".xml";
        InputStream inputStream = this.getResourceAsStream(string4);
        return inputStream;
    }

    protected PlexusContainer getContainer() {
        return this.container;
    }

    private Context getContext() {
        return this.container.getContext();
    }

    protected InputStream getCustomConfiguration() throws Exception {
        return null;
    }

    protected InputStream getResourceAsStream(String string) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(string);
    }

    public static File getTestFile(String string) {
        return new File(PlexusTestCase.getBasedir(), string);
    }

    public static File getTestFile(String string, String string2) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = PlexusTestCase.getTestFile(string);
        }
        return new File(file, string2);
    }

    public static String getTestPath(String string) {
        return PlexusTestCase.getTestFile(string).getAbsolutePath();
    }

    public static String getTestPath(String string, String string2) {
        return PlexusTestCase.getTestFile(string, string2).getAbsolutePath();
    }

    protected Object lookup(String string) throws Exception {
        return this.getContainer().lookup(string);
    }

    protected Object lookup(String string, String string2) throws Exception {
        return this.getContainer().lookup(string, string2);
    }

    protected void release(Object object) throws Exception {
        this.getContainer().release(object);
    }

    protected void setUp() throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = this.getCustomConfiguration();
            if (inputStream == null) {
                inputStream = this.getConfiguration();
            }
        }
        catch (Exception exception) {
            System.out.println("Error with configuration:");
            System.out.println("configuration = " + inputStream);
            Assert.fail((String)exception.getMessage());
        }
        this.basedir = PlexusTestCase.getBasedir();
        this.container = this.createContainerInstance();
        this.container.addContextValue("basedir", PlexusTestCase.getBasedir());
        this.customizeContext();
        this.customizeContext(this.getContext());
        boolean bl = this.getContext().contains("plexus.home");
        if (!bl) {
            File file = PlexusTestCase.getTestFile("target/plexus-home");
            if (!file.isDirectory()) {
                file.mkdir();
            }
            this.getContext().put("plexus.home", file.getAbsolutePath());
        }
        if (inputStream != null) {
            this.container.setConfigurationResource(new InputStreamReader(inputStream));
        }
        this.container.initialize();
        this.container.start();
    }

    protected void tearDown() throws Exception {
        this.container.dispose();
        this.container = null;
    }
}

