/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.composition.ComponentComposerManager;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.discovery.DiscoveryListenerDescriptor;
import org.codehaus.plexus.component.factory.ComponentFactory;
import org.codehaus.plexus.component.factory.ComponentFactoryManager;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.manager.ComponentManagerManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfigurationMerger;
import org.codehaus.plexus.configuration.PlexusConfigurationResourceException;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessor;
import org.codehaus.plexus.configuration.processor.DirectoryConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.FileConfigurationResourceHandler;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.lifecycle.LifecycleHandlerManager;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLoggerManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.InterpolationFilterReader;

public class DefaultPlexusContainer
extends AbstractLogEnabled
implements PlexusContainer {
    private PlexusContainer parentContainer;
    private LoggerManager loggerManager;
    private DefaultContext context = new DefaultContext();
    protected PlexusConfiguration configuration;
    private Reader configurationReader;
    private ClassWorld classWorld;
    private ClassRealm coreRealm;
    private ClassRealm plexusRealm;
    private String name;
    private ComponentRepository componentRepository;
    private ComponentManagerManager componentManagerManager;
    private LifecycleHandlerManager lifecycleHandlerManager;
    private ComponentDiscovererManager componentDiscovererManager;
    private ComponentFactoryManager componentFactoryManager;
    private ComponentComposerManager componentComposerManager;
    private Map realmAliases;
    public static final String BOOTSTRAP_CONFIGURATION = "org/codehaus/plexus/plexus-bootstrap.xml";
    static /* synthetic */ Class class$org$codehaus$plexus$PlexusContainer;

    public DefaultPlexusContainer() {
        this.loggerManager = new ConsoleLoggerManager("debug");
        this.enableLogging(this.loggerManager.getLoggerForComponent((class$org$codehaus$plexus$PlexusContainer != null ? class$org$codehaus$plexus$PlexusContainer : (class$org$codehaus$plexus$PlexusContainer = DefaultPlexusContainer.class$("org.codehaus.plexus.PlexusContainer"))).getName()));
    }

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentRepositoryException {
        this.componentRepository.addComponentDescriptor(componentDescriptor);
    }

    public void addContextValue(Object object, Object object2) {
        this.context.put(object, object2);
    }

    public void addJarRepository(File file) throws Exception {
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].getAbsolutePath().endsWith(".jar")) {
                    this.addJarResource(fileArray[n]);
                }
                ++n;
            }
        } else {
            this.getLogger().warn("The specified JAR repository doesn't exist or is not a directory.");
        }
    }

    public void addJarResource(File file) throws Exception {
        this.plexusRealm.addConstituent(file.toURL());
    }

    protected void addRealmAlias(String string, String string2) {
        this.realmAliases.put(string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void composeComponent(Object object, ComponentDescriptor componentDescriptor) throws Exception {
        this.componentComposerManager.assembleComponent(object, componentDescriptor, this);
    }

    public Object createComponentInstance(ComponentDescriptor componentDescriptor) throws Exception {
        String string = componentDescriptor.getComponentFactory();
        ComponentFactory componentFactory = null;
        componentFactory = string != null ? this.componentFactoryManager.findComponentFactory(string) : this.componentFactoryManager.getDefaultComponentFactory();
        return componentFactory.newInstance(componentDescriptor, this.plexusRealm, this);
    }

    private ComponentManager createComponentManager(ComponentDescriptor componentDescriptor) throws ComponentLookupException {
        ComponentManager componentManager;
        try {
            componentManager = this.componentManagerManager.createComponentManager(componentDescriptor, this);
        }
        catch (Exception exception) {
            String string = "Cannot create component manager for " + componentDescriptor.getComponentKey() + ", so we cannot provide a component instance.";
            this.getLogger().error(string, exception);
            throw new ComponentLookupException(string, exception);
        }
        return componentManager;
    }

    public List discoverComponents(ClassRealm classRealm) throws Exception {
        ArrayList<ComponentDescriptor> arrayList = new ArrayList<ComponentDescriptor>();
        Iterator iterator = this.componentDiscovererManager.getComponentDiscoverers().iterator();
        while (iterator.hasNext()) {
            ComponentDiscoverer componentDiscoverer = (ComponentDiscoverer)iterator.next();
            List list = componentDiscoverer.findComponents(this.getContext(), classRealm);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                ComponentSetDescriptor componentSetDescriptor = (ComponentSetDescriptor)iterator2.next();
                List list2 = componentSetDescriptor.getComponents();
                Iterator iterator3 = list2.iterator();
                while (iterator3.hasNext()) {
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)iterator3.next();
                    componentDescriptor.setComponentSetDescriptor(componentSetDescriptor);
                    if (this.getComponentDescriptor(componentDescriptor.getComponentKey()) != null) continue;
                    this.addComponentDescriptor(componentDescriptor);
                    arrayList.add(componentDescriptor);
                }
            }
        }
        return arrayList;
    }

    public void dispose() {
        this.disposeAllComponents();
    }

    protected void disposeAllComponents() {
        Iterator iterator = this.componentManagerManager.getComponentManagers().values().iterator();
        while (iterator.hasNext()) {
            try {
                ((ComponentManager)iterator.next()).dispose();
            }
            catch (Exception exception) {
                this.getLogger().error("Error while disposing component manager. Continuing with the rest", exception);
            }
        }
        this.componentManagerManager.getComponentManagers().clear();
    }

    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public ComponentDescriptor getComponentDescriptor(String string) {
        ComponentDescriptor componentDescriptor = this.componentRepository.getComponentDescriptor(string);
        if (componentDescriptor == null && this.parentContainer != null) {
            componentDescriptor = this.parentContainer.getComponentDescriptor(string);
        }
        return componentDescriptor;
    }

    public List getComponentDescriptorList(String string) {
        ArrayList<Object> arrayList = null;
        Map map = this.getComponentDescriptorMap(string);
        arrayList = map != null ? new ArrayList(map.values()) : new ArrayList();
        ComponentDescriptor componentDescriptor = this.getComponentDescriptor(string);
        if (componentDescriptor != null) {
            arrayList.add(componentDescriptor);
        }
        return arrayList;
    }

    public Map getComponentDescriptorMap(String string) {
        Map map;
        Map map2 = null;
        if (this.parentContainer != null) {
            map2 = this.parentContainer.getComponentDescriptorMap(string);
        }
        if ((map = this.componentRepository.getComponentDescriptorMap(string)) != null) {
            if (map2 != null) {
                map2.putAll(map);
            } else {
                map2 = map;
            }
        }
        return map2;
    }

    public ClassRealm getComponentRealm(String string) {
        ClassRealm classRealm;
        try {
            if (this.realmAliases.get(string) != null) {
                string = (String)this.realmAliases.get(string);
            }
            classRealm = this.classWorld.getRealm(string);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            classRealm = this.plexusRealm;
        }
        return classRealm;
    }

    protected ClassRealm getContainerRealm() {
        return this.plexusRealm;
    }

    public Context getContext() {
        return this.context;
    }

    public ClassRealm getCoreRealm() {
        return this.coreRealm;
    }

    protected Reader getInterpolationConfigurationReader(Reader reader) {
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader(reader, new ContextMapAdapter(this.context));
        return interpolationFilterReader;
    }

    public Logger getLogger() {
        return super.getLogger();
    }

    public String getName() {
        return this.name;
    }

    protected Map getRealmAliases() {
        return this.realmAliases;
    }

    public boolean hasComponent(String string) {
        return this.componentRepository.hasComponent(string);
    }

    public boolean hasComponent(String string, String string2) {
        return this.componentRepository.hasComponent(string, string2);
    }

    public void initialize() throws Exception {
        this.realmAliases = new HashMap();
        this.initializeClassWorlds();
        this.initializeConfiguration();
        this.initializeResources();
        this.initializeCoreComponents();
        this.initializeLoggerManager();
        this.initializeContext();
        this.initializeSystemProperties();
    }

    private void initializeClassWorlds() throws Exception {
        if (this.classWorld == null) {
            this.classWorld = new ClassWorld();
        }
        this.initializeName();
        if (this.coreRealm == null) {
            try {
                this.coreRealm = this.classWorld.getRealm("plexus.core");
            }
            catch (NoSuchRealmException noSuchRealmException) {
                this.coreRealm = this.classWorld.newRealm("plexus.core", Thread.currentThread().getContextClassLoader());
            }
        }
        if (this.plexusRealm == null) {
            try {
                this.plexusRealm = this.coreRealm.getWorld().getRealm("plexus.core.maven");
            }
            catch (NoSuchRealmException noSuchRealmException) {
                this.plexusRealm = this.coreRealm;
            }
            this.addContextValue("common.classloader", this.plexusRealm.getClassLoader());
            Thread.currentThread().setContextClassLoader(this.plexusRealm.getClassLoader());
        }
    }

    private void initializeClassWorlds2() throws Exception {
        if (this.classWorld == null) {
            this.classWorld = new ClassWorld();
        }
        this.initializeName();
        if (this.coreRealm == null) {
            try {
                this.coreRealm = this.classWorld.getRealm("plexus.core");
            }
            catch (NoSuchRealmException noSuchRealmException) {
                this.plexusRealm = this.classWorld.newRealm("plexus.core", Thread.currentThread().getContextClassLoader());
            }
        }
        if (this.plexusRealm == null) {
            try {
                this.plexusRealm = this.coreRealm.getWorld().getRealm("plexus." + this.getName());
            }
            catch (NoSuchRealmException noSuchRealmException) {
                this.plexusRealm = this.coreRealm.getWorld().newRealm("plexus." + this.getName());
            }
            this.plexusRealm.importFrom(this.coreRealm.getId(), "");
            this.addContextValue("common.classloader", this.plexusRealm.getClassLoader());
            Thread.currentThread().setContextClassLoader(this.plexusRealm.getClassLoader());
        }
    }

    protected void initializeConfiguration() throws Exception {
        Object object;
        InputStream inputStream = this.coreRealm.getResourceAsStream(BOOTSTRAP_CONFIGURATION);
        if (inputStream == null) {
            throw new IllegalStateException("The internal default plexus.conf is missing. This is highly irregular, your plexus JAR is most likely corrupt.");
        }
        PlexusConfiguration plexusConfiguration = PlexusTools.buildConfiguration(new InputStreamReader(inputStream));
        String string = "META-INF/plexus/plexus.xml";
        InputStream inputStream2 = this.plexusRealm.getResourceAsStream(string);
        this.configuration = plexusConfiguration;
        if (inputStream2 != null) {
            object = PlexusTools.buildConfiguration(this.getInterpolationConfigurationReader(new InputStreamReader(inputStream2)));
            this.configuration = PlexusConfigurationMerger.merge((PlexusConfiguration)object, this.configuration);
            this.processConfigurationsDirectory();
        }
        if (this.configurationReader != null) {
            object = PlexusTools.buildConfiguration(this.getInterpolationConfigurationReader(this.configurationReader));
            this.configuration = PlexusConfigurationMerger.merge((PlexusConfiguration)object, this.configuration);
            this.processConfigurationsDirectory();
        }
        object = new ConfigurationProcessor();
        ((ConfigurationProcessor)object).addConfigurationResourceHandler(new FileConfigurationResourceHandler());
        ((ConfigurationProcessor)object).addConfigurationResourceHandler(new DirectoryConfigurationResourceHandler());
        this.configuration = ((ConfigurationProcessor)object).process(this.configuration, new HashMap());
    }

    private void initializeContext() {
        this.addContextValue("plexus", this);
        this.addContextValue("coreRealm", this.plexusRealm);
    }

    private void initializeCoreComponents() throws Exception {
        BasicComponentConfigurator basicComponentConfigurator = new BasicComponentConfigurator();
        PlexusConfiguration plexusConfiguration = this.configuration.getChild("component-repository");
        this.processCoreComponentConfiguration("component-repository", basicComponentConfigurator, plexusConfiguration);
        this.componentRepository.configure(this.configuration);
        this.componentRepository.setClassRealm(this.plexusRealm);
        this.componentRepository.initialize();
        plexusConfiguration = this.configuration.getChild("lifecycle-handler-manager");
        this.processCoreComponentConfiguration("lifecycle-handler-manager", basicComponentConfigurator, plexusConfiguration);
        this.lifecycleHandlerManager.initialize();
        plexusConfiguration = this.configuration.getChild("component-manager-manager");
        this.processCoreComponentConfiguration("component-manager-manager", basicComponentConfigurator, plexusConfiguration);
        this.componentManagerManager.setLifecycleHandlerManager(this.lifecycleHandlerManager);
        plexusConfiguration = this.configuration.getChild("component-discoverer-manager");
        this.processCoreComponentConfiguration("component-discoverer-manager", basicComponentConfigurator, plexusConfiguration);
        this.componentDiscovererManager.initialize();
        plexusConfiguration = this.configuration.getChild("component-factory-manager");
        this.processCoreComponentConfiguration("component-factory-manager", basicComponentConfigurator, plexusConfiguration);
        plexusConfiguration = this.configuration.getChild("component-composer-manager");
        this.processCoreComponentConfiguration("component-composer-manager", basicComponentConfigurator, plexusConfiguration);
    }

    private void initializeLoggerManager() throws Exception {
        this.loggerManager = (LoggerManager)this.lookup(LoggerManager.ROLE);
        this.enableLogging(this.loggerManager.getLoggerForComponent((class$org$codehaus$plexus$PlexusContainer != null ? class$org$codehaus$plexus$PlexusContainer : (class$org$codehaus$plexus$PlexusContainer = DefaultPlexusContainer.class$("org.codehaus.plexus.PlexusContainer"))).getName()));
    }

    protected void initializeName() {
        if (this.name == null) {
            int n = 0;
            try {
                while (true) {
                    this.classWorld.getRealm("plexus.app" + n);
                    ++n;
                }
            }
            catch (NoSuchRealmException noSuchRealmException) {
                this.setName("app" + n);
                return;
            }
        }
    }

    public void initializeResources() throws PlexusConfigurationException {
        PlexusConfiguration[] plexusConfigurationArray = this.configuration.getChild("resources").getChildren();
        int n = 0;
        while (n < plexusConfigurationArray.length) {
            try {
                String string = plexusConfigurationArray[n].getName();
                if (string.equals("jar-repository")) {
                    this.addJarRepository(new File(plexusConfigurationArray[n].getValue()));
                } else if (string.equals("directory")) {
                    File file = new File(plexusConfigurationArray[n].getValue());
                    if (file.exists() && file.isDirectory()) {
                        this.plexusRealm.addConstituent(file.toURL());
                    }
                } else {
                    this.getLogger().warn("Unknown resource type: " + string);
                }
            }
            catch (Exception exception) {
                this.getLogger().error("Error configuring resource: " + plexusConfigurationArray[n].getName() + "=" + plexusConfigurationArray[n].getValue(), exception);
            }
            ++n;
        }
    }

    private void initializeSystemProperties() throws PlexusConfigurationException {
        PlexusConfiguration[] plexusConfigurationArray = this.configuration.getChild("system-properties").getChildren("property");
        int n = 0;
        while (n < plexusConfigurationArray.length) {
            String string = plexusConfigurationArray[n].getAttribute("name");
            String string2 = plexusConfigurationArray[n].getAttribute("value");
            if (string == null) {
                throw new PlexusConfigurationException("Missing 'name' attribute in 'property' tag. ");
            }
            if (string2 == null) {
                throw new PlexusConfigurationException("Missing 'value' attribute in 'property' tag. ");
            }
            System.getProperties().setProperty(string, string2);
            this.getLogger().info("Setting system property: [ " + string + ", " + string2 + " ]");
            ++n;
        }
    }

    protected void loadComponentsOnStart() throws PlexusConfigurationException, ComponentLookupException {
        PlexusConfiguration[] plexusConfigurationArray = this.configuration.getChild("load-on-start").getChildren("component");
        this.getLogger().debug("Found " + plexusConfigurationArray.length + " components to load on start");
        int n = 0;
        while (n < plexusConfigurationArray.length) {
            String string = plexusConfigurationArray[n].getChild("role").getValue(null);
            String string2 = plexusConfigurationArray[n].getChild("role-hint").getValue();
            if (string == null) {
                throw new PlexusConfigurationException("Missing 'role' element from load-on-start.");
            }
            if (string2 == null) {
                this.getLogger().info("Loading on start [role]: [" + string + "]");
                this.lookup(string);
            } else if (string2.equals("*")) {
                this.getLogger().info("Loading on start all components with [role]: [" + string + "]");
                this.lookupList(string);
            } else {
                this.getLogger().info("Loading on start [role,roleHint]: [" + string + "," + string2 + "]");
                this.lookup(string, string2);
            }
            ++n;
        }
    }

    public Object lookup(String string) throws ComponentLookupException {
        Object object = null;
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentKey(string);
        if (componentManager == null) {
            ComponentDescriptor componentDescriptor = this.componentRepository.getComponentDescriptor(string);
            if (componentDescriptor == null) {
                if (this.parentContainer != null) {
                    return this.parentContainer.lookup(string);
                }
                this.getLogger().error("Nonexistent component: " + string);
                String string2 = "Component descriptor cannot be found in the component repository: " + string + ".";
                throw new ComponentLookupException(string2);
            }
            componentManager = this.createComponentManager(componentDescriptor);
        }
        try {
            object = componentManager.getComponent();
            this.componentManagerManager.associateComponentWithComponentManager(object, componentManager);
        }
        catch (Exception exception) {
            String string3 = "Cannot create component for " + string + ".";
            this.getLogger().error(string3, exception);
            throw new ComponentLookupException(string3, exception);
        }
        return object;
    }

    public Object lookup(String string, String string2) throws ComponentLookupException {
        return this.lookup(String.valueOf(string) + string2);
    }

    public List lookupList(String string) throws ComponentLookupException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = this.getComponentDescriptorList(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)iterator.next();
                String string2 = componentDescriptor.getRoleHint();
                Object object = string2 != null ? this.lookup(string, string2) : this.lookup(string);
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public Map lookupMap(String string) throws ComponentLookupException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map map = this.getComponentDescriptorMap(string);
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object object = this.lookup(string, string2);
                hashMap.put(string2, object);
            }
        }
        return hashMap;
    }

    private void processConfigurationsDirectory() throws Exception {
        String string = this.configuration.getChild("configurations-directory").getValue(null);
        if (string != null) {
            PlexusConfiguration plexusConfiguration = this.configuration.getChild("components");
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                List list = FileUtils.getFiles(file, "**/*.conf", "**/*.xml");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    File file2 = (File)iterator.next();
                    PlexusConfiguration plexusConfiguration2 = PlexusTools.buildConfiguration(this.getInterpolationConfigurationReader(new FileReader(file2)));
                    plexusConfiguration.addChild(plexusConfiguration2.getChild("components"));
                }
            }
        }
    }

    private void processCoreComponentConfiguration(String string, BasicComponentConfigurator basicComponentConfigurator, PlexusConfiguration plexusConfiguration) throws ComponentConfigurationException {
        String string2 = plexusConfiguration.getAttribute("implementation", null);
        if (string2 == null) {
            String string3 = "Core component: '" + string + "' + which is needed by plexus to function properly cannot " + "be instantiated. Implementation attribute was not specified in plexus.conf." + "This is highly irregular, your plexus JAR is most likely corrupt.";
            throw new ComponentConfigurationException(string3);
        }
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.setRole(string);
        componentDescriptor.setImplementation(string2);
        XmlPlexusConfiguration xmlPlexusConfiguration = new XmlPlexusConfiguration("configuration");
        xmlPlexusConfiguration.addChild(plexusConfiguration);
        basicComponentConfigurator.configureComponent(this, componentDescriptor, xmlPlexusConfiguration);
    }

    public void registerComponentDiscoveryListener(ComponentDiscoveryListener componentDiscoveryListener) {
        this.componentDiscovererManager.registerComponentDiscoveryListener(componentDiscoveryListener);
    }

    public void registerComponentDiscoverytListeners() throws Exception {
        List list = this.componentDiscovererManager.getListenerDescriptors();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DiscoveryListenerDescriptor discoveryListenerDescriptor = (DiscoveryListenerDescriptor)iterator.next();
                String string = discoveryListenerDescriptor.getRole();
                ComponentDiscoveryListener componentDiscoveryListener = (ComponentDiscoveryListener)this.lookup(string);
                this.componentDiscovererManager.registerComponentDiscoveryListener(componentDiscoveryListener);
            }
        }
    }

    public void release(Object object) throws Exception {
        if (object == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(object);
        if (componentManager == null) {
            if (this.parentContainer != null) {
                this.parentContainer.release(object);
            } else {
                this.getLogger().warn("Component manager not found for returned component. Ignored. component=" + object);
            }
        } else {
            componentManager.release(object);
        }
    }

    public void releaseAll(List list) throws Exception {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.release(e);
        }
    }

    public void releaseAll(Map map) throws Exception {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            this.release(v);
        }
    }

    public void removeComponentDiscoveryListener(ComponentDiscoveryListener componentDiscoveryListener) {
        this.componentDiscovererManager.removeComponentDiscoveryListener(componentDiscoveryListener);
    }

    public void resume(Object object) throws Exception {
        if (object == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(object);
        componentManager.resume(object);
    }

    public void setClassWorld(ClassWorld classWorld) {
        this.classWorld = classWorld;
    }

    public void setConfigurationResource(Reader reader) throws PlexusConfigurationResourceException {
        this.configurationReader = reader;
    }

    public void setCoreRealm(ClassRealm classRealm) {
        this.coreRealm = classRealm;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParentPlexusContainer(PlexusContainer plexusContainer) {
        this.parentContainer = plexusContainer;
    }

    public void start() throws Exception {
        this.registerComponentDiscoverytListeners();
        this.discoverComponents(this.plexusRealm);
        this.loadComponentsOnStart();
        this.configuration = null;
    }

    public void suspend(Object object) throws Exception {
        if (object == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(object);
        componentManager.suspend(object);
    }
}

