/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.factory.DefaultArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.plexus.ArtifactEnabledContainer;
import org.codehaus.plexus.ArtifactEnabledContainerException;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public class DefaultArtifactEnabledContainer
extends DefaultPlexusContainer
implements ArtifactEnabledContainer {
    private ArtifactFactory artifactFactory = new DefaultArtifactFactory();
    int realmTmpId = 0;

    private Artifact createArtifact(ComponentDependency cd) {
        return this.artifactFactory.createArtifact(cd.getGroupId(), cd.getArtifactId(), cd.getVersion(), "runtime", cd.getType());
    }

    public void addComponent(Artifact component, ArtifactResolver artifactResolver, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource sourceReader, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactEnabledContainerException {
        ClassRealm componentRealm;
        boolean dependencyComponentsDiscovered = false;
        artifactResolver.resolve(component, remoteRepositories, localRepository);
        ++this.realmTmpId;
        ClassWorld classWorld = this.getClassWorld();
        List componentDescriptors = null;
        try {
            ClassRealm tmp = classWorld.newRealm("tmp" + this.realmTmpId);
            tmp.addConstituent(this.getArtifactUrl(component));
            componentDescriptors = this.discoverArtifactComponents(tmp);
            classWorld.disposeRealm("tmp" + this.realmTmpId);
        }
        catch (DuplicateRealmException e) {
            throw new ArtifactEnabledContainerException("Unable to add component class realm", e);
        }
        catch (NoSuchRealmException e) {
            throw new ArtifactEnabledContainerException("Unable to add component class realm", e);
        }
        ClassRealm plexusRealm = this.getContainerRealm();
        String realmId = component.getId();
        try {
            componentRealm = plexusRealm.createChildRealm(realmId);
        }
        catch (DuplicateRealmException e) {
            throw new ArtifactEnabledContainerException("Unable to add component class realm", e);
        }
        Iterator i = componentDescriptors.iterator();
        while (i.hasNext()) {
            Iterator j;
            ComponentDescriptor componentDescriptor = (ComponentDescriptor)i.next();
            String componentKey = componentDescriptor.getComponentKey();
            this.addRealmAlias(componentKey, realmId);
            if (componentDescriptor.getComponentSetDescriptor().getDependencies() != null) {
                HashSet<Artifact> artifactsToResolve = new HashSet<Artifact>();
                j = componentDescriptor.getComponentSetDescriptor().getDependencies().iterator();
                while (j.hasNext()) {
                    ComponentDependency cd = (ComponentDependency)j.next();
                    Artifact componentArtifact = this.createArtifact(cd);
                    if (!filter.include(componentArtifact)) continue;
                    artifactsToResolve.add(componentArtifact);
                }
                ArtifactResolutionResult result = artifactResolver.resolveTransitively(artifactsToResolve, remoteRepositories, localRepository, sourceReader, filter);
                Iterator k = result.getArtifacts().values().iterator();
                while (k.hasNext()) {
                    Artifact a = (Artifact)k.next();
                    if (!filter.include(a)) continue;
                    componentRealm.addConstituent(this.getArtifactUrl(a));
                }
            }
            if (!dependencyComponentsDiscovered) {
                List dependencyComponents = this.discoverArtifactComponents(componentRealm);
                j = dependencyComponents.iterator();
                while (j.hasNext()) {
                    ComponentDescriptor dcd = (ComponentDescriptor)j.next();
                    this.addRealmAlias(dcd.getComponentKey(), realmId);
                }
                dependencyComponentsDiscovered = true;
            }
            componentRealm.addConstituent(this.getArtifactUrl(component));
        }
    }

    private List discoverArtifactComponents(ClassRealm tmp) throws ArtifactEnabledContainerException {
        try {
            return this.discoverComponents(tmp);
        }
        catch (PlexusConfigurationException e) {
            throw new ArtifactEnabledContainerException("Error discovering components", e);
        }
        catch (ComponentRepositoryException e) {
            throw new ArtifactEnabledContainerException("Error discovering components", e);
        }
    }

    private URL getArtifactUrl(Artifact component) throws ArtifactEnabledContainerException {
        try {
            return component.getFile().toURL();
        }
        catch (MalformedURLException e) {
            throw new ArtifactEnabledContainerException("Error constructing file URL", e);
        }
    }
}

