/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;

public abstract class AbstractCompilerTest
extends PlexusTestCase {
    private Compiler compiler = null;
    private String mavenRepoLocal;
    protected String roleHint;
    private CompilerConfiguration compilerConfig;

    protected int expectedErrors() {
        return 1;
    }

    protected List getClasspath() {
        return Collections.singletonList(String.valueOf(this.mavenRepoLocal) + "/commons-lang/jars/commons-lang-2.0.jar");
    }

    protected CompilerConfiguration getCompilerConfiguration() {
        return this.compilerConfig;
    }

    protected String getMavenRepoLocal() {
        return this.mavenRepoLocal;
    }

    protected abstract String getRoleHint();

    public void setUp() throws Exception {
        super.setUp();
        String basedir = PlexusTestCase.getBasedir();
        basedir = System.getProperty("basedir");
        this.compiler = (Compiler)this.lookup(Compiler.ROLE, this.getRoleHint());
        this.mavenRepoLocal = System.getProperty("maven.repo.local");
        if (this.mavenRepoLocal == null) {
            this.mavenRepoLocal = System.getProperty("maven.repo.local");
        }
        if (this.mavenRepoLocal == null) {
            this.mavenRepoLocal = new File(System.getProperty("user.home"), ".maven/repository").getPath();
        }
        this.compilerConfig = new CompilerConfiguration();
        this.compilerConfig.setClasspathEntries(this.getClasspath());
        this.compilerConfig.addSourceLocation(String.valueOf(basedir) + "/src/test-input/src/main");
        this.compilerConfig.setOutputLocation(String.valueOf(basedir) + "/target/" + this.getRoleHint() + "/classes");
        this.compilerConfig.addInclude("**/*.java");
    }

    public void testCompilingSources() throws Exception {
        List messages = this.compiler.compile(this.compilerConfig);
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
        Assert.assertEquals((String)("Expected number of compilation errors is" + this.expectedErrors()), (int)this.expectedErrors(), (int)messages.size());
    }
}

