/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.jikes;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.util.StreamPumper;
import org.codehaus.plexus.util.StringUtils;

public class JikesCompiler
extends AbstractCompiler {
    static final int OUTPUT_BUFFER_SIZE = 1024;

    public List compile(CompilerConfiguration config) throws Exception {
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        String javaHome = System.getProperty("java.home");
        List messages = null;
        String[] sources = this.getSourceFiles(config);
        int j = 9;
        String[] args = new String[sources.length + j];
        args[0] = "jikes";
        args[1] = "-bootclasspath";
        args[2] = new File(javaHome, "lib/rt.jar").getPath();
        args[3] = "-classpath";
        List classpathEntries = config.getClasspathEntries();
        args[4] = this.getPathString(classpathEntries);
        args[5] = "+E";
        args[6] = "-nowarn";
        args[7] = "-d";
        args[8] = destinationDir.getAbsolutePath();
        for (int i = 0; i < sources.length; ++i) {
            args[i + j] = sources[i];
        }
        ByteArrayOutputStream tmpErr = new ByteArrayOutputStream(1024);
        try {
            Process p = Runtime.getRuntime().exec(args);
            BufferedInputStream compilerErr = new BufferedInputStream(p.getErrorStream());
            StreamPumper errPumper = new StreamPumper(compilerErr, (OutputStream)tmpErr);
            errPumper.start();
            p.waitFor();
            int exitValue = p.exitValue();
            errPumper.join();
            compilerErr.close();
            p.destroy();
            tmpErr.close();
            messages = this.parseStream(new BufferedReader(new InputStreamReader(new ByteArrayInputStream(tmpErr.toByteArray()))));
        }
        catch (InterruptedException e) {
            this.getLogger().debug("Jikes.compile():SomethingHappened", (Throwable)e);
        }
        return messages;
    }

    protected List parseStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = null;
        String line = null;
        StringBuffer buffer = null;
        while (true) {
            buffer = new StringBuffer();
            if (line == null) {
                line = input.readLine();
            }
            if (line == null) {
                return errors;
            }
            buffer.append(line);
            while ((line = input.readLine()) != null && (line.length() <= 0 || line.charAt(0) == ' ')) {
                buffer.append('\n');
                buffer.append(line);
            }
            if (errors == null) {
                errors = new ArrayList<CompilerError>();
            }
            if (buffer.length() <= 0) continue;
            errors.add(this.parseError(buffer.toString()));
        }
    }

    private CompilerError parseError(String error) {
        String file;
        String[] errorBits = StringUtils.split((String)error, (String)":");
        int i = 0;
        if (System.getProperty("os.name").startsWith("Windows")) {
            file = errorBits[0] + ":" + errorBits[1];
            i = 2;
        } else {
            file = errorBits[0];
            i = 1;
        }
        int startline = Integer.parseInt(errorBits[i++]);
        int startcolumn = Integer.parseInt(errorBits[i++]);
        int endline = Integer.parseInt(errorBits[i++]);
        int endcolumn = Integer.parseInt(errorBits[i++]);
        String type = errorBits[i++];
        String message = errorBits[i++];
        return new CompilerError(file, type.equals("error"), startline, startcolumn, endline, endcolumn, message.toString());
    }

    public String toString() {
        return "IBM Jikes Compiler";
    }
}

