/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.personality.avalon;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public class AvalonConfiguration
implements Configuration {
    PlexusConfiguration config;

    public AvalonConfiguration(PlexusConfiguration config) {
        this.config = config;
    }

    public String getName() {
        return this.config.getName();
    }

    public String getLocation() {
        throw new UnsupportedOperationException();
    }

    public String getNamespace() throws ConfigurationException {
        throw new UnsupportedOperationException();
    }

    public Configuration getChild(String child) {
        return new AvalonConfiguration(this.config.getChild(child));
    }

    public Configuration getChild(String child, boolean value) {
        return new AvalonConfiguration(this.config.getChild(child, value));
    }

    public Configuration[] getChildren() {
        PlexusConfiguration[] children = this.config.getChildren();
        ArrayList<AvalonConfiguration> childList = new ArrayList<AvalonConfiguration>();
        int i = 0;
        while (i < children.length) {
            childList.add(new AvalonConfiguration(children[i]));
            ++i;
        }
        return childList.toArray(new AvalonConfiguration[0]);
    }

    public Configuration[] getChildren(String name) {
        PlexusConfiguration[] children = this.config.getChildren(name);
        ArrayList<AvalonConfiguration> childList = new ArrayList<AvalonConfiguration>();
        int i = 0;
        while (i < children.length) {
            childList.add(new AvalonConfiguration(children[i]));
            ++i;
        }
        return childList.toArray(new AvalonConfiguration[0]);
    }

    public String[] getAttributeNames() {
        return this.config.getAttributeNames();
    }

    public String getAttribute(String attr) throws ConfigurationException {
        try {
            return this.config.getAttribute(attr);
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationException("ConfigurationException.", e.getCause());
        }
    }

    public int getAttributeAsInteger(String attr) throws ConfigurationException {
        try {
            return this.getAttributeAsInteger(this.config, attr);
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationException("ConfigurationException.", e.getCause());
        }
    }

    public long getAttributeAsLong(String attr) throws ConfigurationException {
        try {
            return this.getAttributeAsLong(this.config, attr);
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationException("ConfigurationException.", e.getCause());
        }
    }

    public float getAttributeAsFloat(String attr) throws ConfigurationException {
        try {
            return this.getAttributeAsFloat(this.config, attr);
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationException("ConfigurationException.", e.getCause());
        }
    }

    public boolean getAttributeAsBoolean(String attr) throws ConfigurationException {
        try {
            return this.getAttributeAsBoolean(this.config, attr);
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationException("ConfigurationException.", e.getCause());
        }
    }

    public String getValue() throws ConfigurationException {
        try {
            return this.config.getValue();
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationException("ConfigurationException.", e.getCause());
        }
    }

    public int getValueAsInteger() throws ConfigurationException {
        try {
            return this.getValueAsInteger(this.config);
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationException("ConfigurationException.", e.getCause());
        }
    }

    public float getValueAsFloat() throws ConfigurationException {
        try {
            return this.getValueAsFloat(this.config);
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationException("ConfigurationException.", e.getCause());
        }
    }

    public boolean getValueAsBoolean() throws ConfigurationException {
        try {
            return this.getValueAsBoolean(this.config);
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationException("ConfigurationException.", e.getCause());
        }
    }

    public long getValueAsLong() throws ConfigurationException {
        try {
            return this.getValueAsLong(this.config);
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationException("ConfigurationException.", e.getCause());
        }
    }

    public String getValue(String defaultValue) {
        return this.config.getValue(defaultValue);
    }

    public int getValueAsInteger(int defaultValue) {
        return this.getValueAsInteger(this.config, defaultValue);
    }

    public long getValueAsLong(long defaultValue) {
        return this.getValueAsLong(this.config, defaultValue);
    }

    public float getValueAsFloat(float defaultValue) {
        return this.getValueAsFloat(this.config, defaultValue);
    }

    public boolean getValueAsBoolean(boolean defaultValue) {
        return this.getValueAsBoolean(this.config, defaultValue);
    }

    public String getAttribute(String attr, String defaultValue) {
        return this.config.getAttribute(attr, defaultValue);
    }

    public int getAttributeAsInteger(String attr, int defaultValue) {
        return this.getAttributeAsInteger(this.config, attr, defaultValue);
    }

    public long getAttributeAsLong(String attr, long defaultValue) {
        return this.getAttributeAsLong(this.config, attr, defaultValue);
    }

    public float getAttributeAsFloat(String attr, float defaultValue) {
        return this.getAttributeAsFloat(this.config, attr, defaultValue);
    }

    public boolean getAttributeAsBoolean(String attr, boolean defaultValue) {
        return this.getAttributeAsBoolean(this.config, attr, defaultValue);
    }

    public String getPrefix() {
        throw new UnsupportedOperationException();
    }

    public int getValueAsInteger(PlexusConfiguration configuration) throws PlexusConfigurationException {
        String value = configuration.getValue();
        if (value == null) {
            throw new PlexusConfigurationException("No value.");
        }
        value = value.trim();
        try {
            return Integer.parseInt(value);
        }
        catch (Exception nfe) {
            String message = "Cannot parse the value \"" + value + "\" as an integer in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
            throw new PlexusConfigurationException(message);
        }
    }

    public int getValueAsInteger(PlexusConfiguration configuration, int defaultValue) {
        try {
            return this.getValueAsInteger();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public long getValueAsLong(PlexusConfiguration configuration) throws PlexusConfigurationException {
        String value = configuration.getValue();
        if (value == null) {
            throw new PlexusConfigurationException("No value.");
        }
        value = value.trim();
        try {
            return Long.parseLong(value);
        }
        catch (Exception nfe) {
            String message = "Cannot parse the value \"" + value + "\" as a long in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
            throw new PlexusConfigurationException(message);
        }
    }

    public long getValueAsLong(PlexusConfiguration configuration, long defaultValue) {
        try {
            return this.getValueAsLong();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public float getValueAsFloat(PlexusConfiguration configuration) throws PlexusConfigurationException {
        String value = configuration.getValue();
        if (value == null) {
            throw new PlexusConfigurationException("No value.");
        }
        value = value.trim();
        try {
            return Float.parseFloat(value);
        }
        catch (Exception nfe) {
            String message = "Cannot parse the value \"" + value + "\" as a float in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
            throw new PlexusConfigurationException(message);
        }
    }

    public float getValueAsFloat(PlexusConfiguration configuration, float defaultValue) {
        try {
            return this.getValueAsFloat();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public boolean getValueAsBoolean(PlexusConfiguration configuration) throws PlexusConfigurationException {
        String value = configuration.getValue();
        if (value == null) {
            throw new PlexusConfigurationException("No value.");
        }
        if (this.isTrue(value = value.trim())) {
            return true;
        }
        if (this.isFalse(value)) {
            return false;
        }
        String message = "Cannot parse the value \"" + value + "\" as a boolean in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
        throw new PlexusConfigurationException(message);
    }

    public boolean getValueAsBoolean(PlexusConfiguration configuration, boolean defaultValue) {
        try {
            return this.getValueAsBoolean();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public String getValue(PlexusConfiguration configuration, String defaultValue) {
        try {
            return this.getValue();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public int getAttributeAsInteger(PlexusConfiguration configuration, String name) throws PlexusConfigurationException {
        String value = configuration.getAttribute(name);
        if (value == null) {
            throw new PlexusConfigurationException("No value.");
        }
        value = value.trim();
        try {
            return Integer.parseInt(value);
        }
        catch (Exception nfe) {
            String message = "Cannot parse the value \"" + value + "\" as an integer in the attribute \"" + name + "\" at " + this.getLocation();
            throw new PlexusConfigurationException(message);
        }
    }

    public int getAttributeAsInteger(PlexusConfiguration configuration, String name, int defaultValue) {
        try {
            return this.getAttributeAsInteger(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public long getAttributeAsLong(PlexusConfiguration configuration, String name) throws PlexusConfigurationException {
        String value = configuration.getAttribute(name);
        if (value == null) {
            throw new PlexusConfigurationException("No value.");
        }
        value = value.trim();
        try {
            return Long.parseLong(value);
        }
        catch (Exception nfe) {
            String message = "Cannot parse the value \"" + value + "\" as a long in the attribute \"" + name + "\" at " + this.getLocation();
            throw new PlexusConfigurationException(message);
        }
    }

    public long getAttributeAsLong(PlexusConfiguration configuration, String name, long defaultValue) {
        try {
            return this.getAttributeAsLong(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public float getAttributeAsFloat(PlexusConfiguration configuration, String name) throws PlexusConfigurationException {
        String value = configuration.getAttribute(name);
        if (value == null) {
            throw new PlexusConfigurationException("No value.");
        }
        value = value.trim();
        try {
            return Float.parseFloat(value);
        }
        catch (Exception e) {
            String message = "Cannot parse the value \"" + value + "\" as a float in the attribute \"" + name + "\" at " + this.getLocation();
            throw new PlexusConfigurationException(message);
        }
    }

    public float getAttributeAsFloat(PlexusConfiguration configuration, String name, float defaultValue) {
        try {
            return this.getAttributeAsFloat(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public boolean getAttributeAsBoolean(PlexusConfiguration configuration, String name) throws PlexusConfigurationException {
        String value = configuration.getAttribute(name);
        if (value == null) {
            throw new PlexusConfigurationException("No value.");
        }
        if (this.isTrue(value = value.trim())) {
            return true;
        }
        if (this.isFalse(value)) {
            return false;
        }
        String message = "Cannot parse the value \"" + value + "\" as a boolean in the attribute \"" + name + "\" at " + this.getLocation();
        throw new PlexusConfigurationException(message);
    }

    private boolean isTrue(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("1");
    }

    private boolean isFalse(String value) {
        return value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("0");
    }

    protected boolean getAttributeAsBoolean(PlexusConfiguration configuration, String name, boolean defaultValue) {
        try {
            return this.getAttributeAsBoolean(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public String getAttribute(PlexusConfiguration configuration, String name, String defaultValue) {
        try {
            return this.getAttribute(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }
}

